/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.Language;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.Flags;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Valued;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.VariableCustomRule;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.constraints.PrimitiveTypeCompatibility;
import io.intino.tara.lang.semantics.constraints.flags.AnnotationCoherenceCheckerFactory;
import io.intino.tara.lang.semantics.constraints.flags.FlagChecker;
import io.intino.tara.lang.semantics.constraints.flags.FlagCoherenceCheckerFactory;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class GlobalConstraints {
    public Constraint[] all() {
        return new Constraint[]{this.parentConstraint(), this.referencesInInstances(), this.invalidNodeFlags(), this.duplicatedTags(), this.tagsCoherence(), this.invalidNodeRules(), this.checkVariables(), this.nodeName(), this.facetInstance(), this.abstractFacetTarget(), this.duplicatedFacets(), this.facetTargetAnyWithoutConstrains()};
    }

    private Constraint invalidNodeRules() {
        return element -> {
            Node node = (Node)element;
            for (Node component : node.components()) {
                if (node.rulesOf(component).stream().filter(r -> r instanceof Size).count() <= 1L) continue;
                GlobalConstraints.error("reject.component.with.multiple.size.rule", node);
            }
        };
    }

    private Constraint parentConstraint() {
        return element -> {
            Node node = (Node)element;
            Node parent = node.parent();
            if (parent == null) {
                return;
            }
            parent.resolve();
            String nodeType = node.type();
            if (!parent.type().equals(nodeType.split(":")[0]) && !parent.type().equals(nodeType)) {
                GlobalConstraints.error("reject.parent.different.type", node, Arrays.asList(parent.type(), nodeType));
            }
            if (parent.is(Tag.Instance)) {
                GlobalConstraints.error("reject.sub.of.instance", node);
            }
        };
    }

    private Constraint referencesInInstances() {
        return element -> {
            Node node = (Node)element;
            if (!node.is(Tag.Instance)) {
                return;
            }
            Node reference = node.components().stream().filter(Node::isReference).findFirst().orElse(null);
            if (reference != null) {
                GlobalConstraints.error("reject.reference.in.instance", node, Collections.emptyList());
            }
        };
    }

    private static void error(String message, Element element, List<?> parameters) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element, parameters));
    }

    private static void error(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element));
    }

    private void warning(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticNotification(SemanticNotification.Level.WARNING, message, element));
    }

    private Constraint duplicatedTags() {
        return element -> {
            Node node = (Node)element;
            HashSet<String> tags = new HashSet<String>();
            for (Tag annotation : node.annotations()) {
                if (tags.add(annotation.name())) continue;
                GlobalConstraints.error("reject.duplicate.annotation", node, Arrays.asList(new Serializable[]{annotation, node.type()}));
            }
            tags.clear();
            for (Tag flag : node.flags()) {
                if (tags.add(flag.name())) continue;
                GlobalConstraints.error("reject.duplicate.flag", node, Arrays.asList(new Serializable[]{flag, node.type() + " " + node.name()}));
            }
        };
    }

    private Constraint invalidNodeFlags() {
        return element -> {
            Node node = (Node)element;
            if (node.flags().isEmpty()) {
                return;
            }
            if (node.isReference()) {
                return;
            }
            List<Tag> availableTags = node.container() instanceof NodeRoot ? Flags.forRoot() : Flags.forComponent();
            for (Tag tag : node.flags()) {
                if (this.isInternalFlag(tag) || availableTags.contains((Object)tag)) continue;
                GlobalConstraints.error("reject.invalid.flag", node, Arrays.asList(tag.name(), node.type()));
            }
        };
    }

    private boolean isInternalFlag(Tag tag) {
        return Flags.internalTags().contains((Object)tag);
    }

    private Constraint tagsCoherence() {
        return element -> {
            Node node = (Node)element;
            for (Tag tag : node.flags()) {
                this.checkFlagConstrains(tag.name(), node);
            }
            for (Tag tag : node.annotations()) {
                this.checkAnnotationConstrains(tag.name(), node);
            }
            if (node.isTerminal() && !node.annotations().isEmpty()) {
                GlobalConstraints.error("reject.annotations.in.terminal", node);
            }
        };
    }

    private void checkFlagConstrains(String flag, Node node) throws SemanticException {
        FlagChecker aClass = FlagCoherenceCheckerFactory.get(flag.toLowerCase());
        if (aClass != null) {
            aClass.check(node);
        }
    }

    private void checkAnnotationConstrains(String flag, Node node) throws SemanticException {
        FlagChecker aClass = AnnotationCoherenceCheckerFactory.get(flag.toLowerCase());
        if (aClass != null) {
            aClass.check(node);
        }
    }

    private Constraint checkVariables() {
        return element -> {
            Node node = (Node)element;
            this.inNode(node);
        };
    }

    private void inNode(Node node) throws SemanticException {
        this.checkDuplicates(node.variables());
        this.checkDuplicates(node.parameters());
        for (Variable variable : node.variables()) {
            this.checkVariable(variable);
        }
    }

    private void checkDuplicates(List<? extends Valued> valueds) throws SemanticException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Valued valued : valueds) {
            if (valued.name() == null || valued.name().isEmpty() || names.add(valued.name())) continue;
            GlobalConstraints.error("reject.duplicated.valued", valued, Collections.singletonList(valued.getClass().getSimpleName().contains("Parameter") ? "parameter" : "variable"));
        }
    }

    private void checkVariable(Variable variable) throws SemanticException {
        List<Object> values = variable.values();
        if (variable.container().is(Tag.Instance)) {
            GlobalConstraints.error("reject.variable.in.node", variable);
        } else if (Primitive.WORD.equals((Object)variable.type()) && !values.isEmpty() && !this.hasCorrectValues(variable) && variable.rule() != null) {
            GlobalConstraints.error("reject.invalid.word.values", variable, Collections.singletonList(variable.rule().errorParameters()));
        } else if (Primitive.FUNCTION.equals((Object)variable.type()) && variable.rule() == null) {
            GlobalConstraints.error("reject.nonexisting.variable.rule", variable, Collections.singletonList(variable.type().javaName()));
        } else if (Primitive.REFERENCE.equals((Object)variable.type()) && !this.hasCorrectReferenceValues(variable)) {
            GlobalConstraints.error("reject.default.value.reference.variable", variable);
        } else if (!(Primitive.WORD.equals((Object)variable.type()) || values.isEmpty() || this.compatibleTypes(variable))) {
            GlobalConstraints.error("reject.invalid.variable.type", variable, Collections.singletonList(variable.type().javaName()));
        } else if (variable.isReference() && variable.destinyOfReference() != null && variable.destinyOfReference().is(Tag.Instance)) {
            GlobalConstraints.error("reject.default.value.reference.to.instance", variable);
        } else if (!variable.isReference() && this.isRedefiningTerminal(variable)) {
            GlobalConstraints.error("reject.terminal.variable.redefinition", variable);
        } else if (!values.isEmpty() && !variable.size().accept(values)) {
            GlobalConstraints.error("reject.element.not.in.range", variable, Arrays.asList(variable.size().min(), variable.size().max()));
        } else if (!(values.isEmpty() || values.get(0) instanceof EmptyNode || variable.rule() == null || variable.rule() instanceof NativeRule || this.hasExpressionValue(values) || variable.rule().accept(values, variable.defaultMetric()))) {
            String message = variable.rule().errorMessage();
            GlobalConstraints.error(message == null || message.isEmpty() ? "custom.rule.class.not.comply" : message, variable, Collections.singletonList(variable.rule().errorParameters()));
        }
        this.checkVariableFlags(variable);
        if (variable.name() != null && Character.isUpperCase(variable.name().charAt(0))) {
            this.warning("warning.variable.name.starts.uppercase", variable);
        }
    }

    private boolean isRedefiningTerminal(Variable variable) {
        Language language = variable.language();
        if (language == null || variable.container() == null) {
            return false;
        }
        List<Constraint> constraints = language.constraints(variable.container().type());
        if (constraints == null) {
            return false;
        }
        Constraint constraint = constraints.stream().filter(c -> c instanceof Constraint.Parameter && ((Constraint.Parameter)c).name().equals(variable.name())).findFirst().orElse(null);
        return constraint != null && ((Constraint.Parameter)constraint).flags().contains((Object)Tag.Terminal);
    }

    private boolean hasCorrectReferenceValues(Variable variable) throws SemanticException {
        for (Object value : variable.values()) {
            if (value instanceof EmptyNode || this.hasInstanceValue(variable.values()) || this.hasExpressionValue(variable.values())) continue;
            return false;
        }
        return true;
    }

    private void checkVariableFlags(Variable variable) throws SemanticException {
        if (variable.flags().contains((Object)Tag.Private) && !variable.isInherited() && !this.isInAbstract(variable) && variable.values().isEmpty()) {
            GlobalConstraints.error("reject.private.variable.without.default.value", variable, Collections.singletonList(variable.name()));
        }
        if (variable.flags().contains((Object)Tag.Reactive) && variable.type().equals((Object)Primitive.FUNCTION)) {
            GlobalConstraints.error("reject.invalid.flag", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
        }
        if (!Primitive.WORD.equals((Object)variable.type()) && variable.flags().contains((Object)Tag.Reactive) && variable.rule() != null && variable.rule() instanceof VariableCustomRule) {
            if (variable.values().isEmpty() || this.hasExpressionValue(variable)) {
                GlobalConstraints.error("reject.reactive.variable.with.rules", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
            } else if (variable.rule() instanceof VariableCustomRule || !this.hasExpressionValue(variable)) {
                GlobalConstraints.error("reject.reactive.with.no.expression.value", variable, Arrays.asList(Tag.Reactive.name(), variable.name()));
            }
        }
        List<Tag> availableTags = Flags.forVariable();
        for (Tag tag : variable.flags()) {
            if (availableTags.contains((Object)tag)) continue;
            if (tag.equals((Object)Tag.Instance)) {
                GlobalConstraints.error("reject.variable.in.instance", variable, Collections.singletonList(variable.name()));
                continue;
            }
            GlobalConstraints.error("reject.invalid.flag", variable, Arrays.asList(tag.name(), variable.name()));
        }
        Variable parentVariable = this.findParentVariable(variable);
        if (parentVariable != null) {
            this.checkParentVariables(variable, parentVariable);
        }
    }

    private boolean hasExpressionValue(Variable variable) {
        return variable.values().get(0) instanceof Primitive.Expression || variable.values().get(0) instanceof Primitive.MethodReference;
    }

    private void checkParentVariables(Variable variable, Variable parentVariable) throws SemanticException {
        if (parentVariable.flags().contains((Object)Tag.Reactive) != variable.flags().contains((Object)Tag.Reactive)) {
            GlobalConstraints.error("reject.parent.variable.tags", variable);
        }
    }

    private Variable findParentVariable(Variable variable) {
        Node node = variable.container();
        if (node == null) {
            return null;
        }
        for (Node parent = node.parent(); parent != null; parent = parent.parent()) {
            for (Variable parentVar : parent.variables()) {
                if (!GlobalConstraints.isOverridden(variable, parentVar)) continue;
                return parentVar;
            }
        }
        if (node.facetTarget() != null && node.facetTarget().targetNode() != null) {
            for (Variable parentVar : node.facetTarget().targetNode().variables()) {
                if (!GlobalConstraints.isOverridden(variable, parentVar)) continue;
                return parentVar;
            }
        }
        return null;
    }

    private static boolean isOverridden(Variable variable, Variable parentVar) {
        return parentVar.type() != null && parentVar.type().equals((Object)variable.type()) && parentVar.name() != null && parentVar.name().equals(variable.name());
    }

    private boolean isInAbstract(Variable variable) {
        return variable.container() != null && variable.container().isAbstract();
    }

    private boolean compatibleTypes(Variable variable) {
        Primitive inferredType = PrimitiveTypeCompatibility.inferType(variable.values().get(0));
        return inferredType != null && PrimitiveTypeCompatibility.checkCompatiblePrimitives(variable.isReference() ? Primitive.REFERENCE : variable.type(), inferredType, variable.isMultiple());
    }

    private boolean hasCorrectValues(Variable variable) {
        return variable.values().get(0) instanceof EmptyNode || this.hasExpressionValue(variable.values()) || variable.rule() != null && variable.rule().accept(variable.values());
    }

    private boolean hasExpressionValue(List<Object> values) {
        return !values.isEmpty() && (values.get(0) instanceof Primitive.Expression || values.get(0) instanceof Primitive.MethodReference);
    }

    private boolean hasInstanceValue(List<Object> values) {
        return !values.isEmpty() && this.asPrimitiveReference(values) || this.asNode(values);
    }

    private boolean asNode(List<Object> values) {
        return values.get(0) instanceof Node && ((Node)values.get(0)).is(Tag.Instance);
    }

    private boolean asPrimitiveReference(List<Object> values) {
        return values.get(0) instanceof Primitive.Reference && ((Primitive.Reference)values.get(0)).reference().is(Tag.Instance);
    }

    private Constraint nodeName() {
        return element -> {
            Node node = (Node)element;
            node.resolve();
            if (!node.is(Tag.Instance) && node.isAnonymous()) {
                GlobalConstraints.error("concept.with.no.name", node);
            } else if (node.is(Tag.Instance)) {
                return;
            }
            if (node.container() != null && node.container() != null && !node.isReference() && !node.isAnonymous() && node.name().equals(node.container().name())) {
                GlobalConstraints.error("reject.container.and.component.namesake", node);
            }
        };
    }

    private Constraint facetInstance() {
        return new Constraint(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                if (node.isSub() && node.facetTarget() != null && !node.facetTarget().inherited() && node.facetTarget().owner() == node) {
                    GlobalConstraints.error("reject.target.in.sub", node);
                } else if (node.isFacet() && this.hasSubs(node)) {
                    this.checkTargetExists(node);
                }
            }

            private void checkTargetExists(Node node) throws SemanticException {
                if (node.isFacet() && !node.isReference() && node.facetTarget() == null && !node.isSub()) {
                    GlobalConstraints.error("no.targets.in.facet", node, Collections.singletonList(node.name()));
                }
            }

            private boolean hasSubs(Node node) {
                return !node.subs().isEmpty();
            }
        };
    }

    private Constraint duplicatedFacets() {
        return element -> {
            Node node = (Node)element;
            HashSet<String> facets = new HashSet<String>();
            for (Facet facet : node.facets()) {
                if (facets.add(facet.type())) continue;
                GlobalConstraints.error("reject.duplicated.facet", facet);
            }
        };
    }

    private Constraint facetTargetAnyWithoutConstrains() {
        return element -> {
            Node node = (Node)element;
            if (node.facetTarget() == null) {
                return;
            }
            if (node.facetTarget().target().equals("any") && node.facetTarget().constraints().isEmpty()) {
                GlobalConstraints.error("reject.facet.target.any.without.constrains", node.facetTarget());
            }
        };
    }

    private Constraint abstractFacetTarget() {
        return element -> {
            Node node = (Node)element;
            if ((node.type().equals("MetaFacet") || node.type().equals("Facet")) && node.facetTarget() == null && !node.isAbstract() && node.subs().isEmpty()) {
                GlobalConstraints.error("no.targets.in.facet", node, Collections.singletonList(node.name()));
            }
        };
    }
}

