/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.Resolver;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FacetConstraint
implements Constraint.Facet {
    private final String type;
    private final boolean terminal;
    private final String[] with;
    private final String[] withOut;
    private final List<Constraint> constraints;

    FacetConstraint(String type, boolean terminal, String[] with, String[] withOut) {
        this.type = type;
        this.terminal = terminal;
        this.with = (String[])with.clone();
        this.withOut = (String[])withOut.clone();
        this.constraints = new ArrayList<Constraint>();
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String[] with() {
        return this.with;
    }

    @Override
    public String[] withOut() {
        return this.withOut;
    }

    @Override
    public boolean terminal() {
        return this.terminal;
    }

    @Override
    public List<Constraint> constraints() {
        return this.constraints;
    }

    @Override
    public Constraint.Facet has(Constraint ... requires) {
        this.constraints.addAll(Arrays.asList(requires));
        return this;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Node node = (Node)element;
        Facet facet = FacetConstraint.findFacet(node, this.type);
        if (facet == null && !"any".equals(this.type())) {
            return;
        }
        boolean hasType = this.is(node.types(), this.with);
        boolean hasIncompatibles = this.isAny(node.types(), this.withOut);
        if (!hasType || hasIncompatibles || !this.checkFacetConstrains(node)) {
            if (!hasType) {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.facet.with.no.constrains.in.context", facet, Arrays.asList(this.with)));
            }
            if (hasIncompatibles) {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.incompatible.facets.in.context", facet, Collections.singletonList(String.join((CharSequence)", ", Arrays.asList(this.withOut)))));
            }
        }
    }

    public static Facet findFacet(Node node, String type) {
        for (Facet facet : node.facets()) {
            if (!type.equals(Resolver.shortType(facet.type()))) continue;
            return facet;
        }
        return null;
    }

    private boolean is(List<String> nodeTypes, String[] constraints) {
        List types = nodeTypes.stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        if (constraints == null) {
            return true;
        }
        for (String aType : constraints) {
            if (types.contains(aType)) continue;
            return false;
        }
        return true;
    }

    private boolean isAny(List<String> nodeTypes, String[] constraints) {
        List types = nodeTypes.stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        if (constraints == null) {
            return false;
        }
        for (String aType : constraints) {
            if (!types.contains(aType) || aType.equals(this.type)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFacetConstrains(Node node) throws SemanticException {
        ArrayList<SemanticException> messages = new ArrayList<SemanticException>();
        for (Constraint require : this.constraints) {
            try {
                require.check(node);
            }
            catch (SemanticException e) {
                if (e.level() == SemanticNotification.Level.ERROR) {
                    throw e;
                }
                messages.add(e);
            }
        }
        if (!messages.isEmpty()) {
            throw (SemanticException)messages.get(0);
        }
        return true;
    }

    public String toString() {
        return "Facet " + this.type;
    }
}

