/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.lang.semantics.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ConstraintHelper {
    public static List<String> componentConstrains(List<Constraint> constraints) {
        HashSet<String> types = new HashSet<String>();
        if (constraints == null) {
            return Collections.emptyList();
        }
        types.addAll(ConstraintHelper.components(constraints));
        for (List<Constraint.Component> components : ConstraintHelper.componentsOfOneOf(constraints)) {
            types.addAll(components.stream().map(Constraint.Component::type).collect(Collectors.toList()));
        }
        for (Constraint.Facet facet : constraints.stream().filter(c -> c instanceof Constraint.Facet).map(c -> (Constraint.Facet)c).collect(Collectors.toList())) {
            types.addAll(ConstraintHelper.facetComponents(facet.type(), facet.constraints()));
            for (List<Constraint.Component> components : ConstraintHelper.componentsOfOneOf(facet.constraints())) {
                types.addAll(ConstraintHelper.typesOf(components));
            }
        }
        return new ArrayList<String>(types);
    }

    private static List<List<Constraint.Component>> componentsOfOneOf(List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.OneOf).map(constraint -> ((Constraint.OneOf)constraint).components()).collect(Collectors.toList());
    }

    private static List<String> components(List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.Component && !((Constraint.Component)c).type().isEmpty()).map(c -> ((Constraint.Component)c).type()).collect(Collectors.toList());
    }

    private static List<String> facetComponents(String facet, List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.Component && !((Constraint.Component)c).type().isEmpty()).map(c -> facet + "+" + ((Constraint.Component)c).type()).collect(Collectors.toList());
    }

    private static List<String> typesOf(List<Constraint.Component> constraints) {
        return constraints.stream().filter(c -> c != null && !c.type().isEmpty()).map(Constraint.Component::type).collect(Collectors.toList());
    }

    public static List<Constraint.Parameter> parameterConstrains(List<Constraint> constraints) {
        List<Constraint.Parameter> parameters = ConstraintHelper.filterParameters(constraints);
        for (Constraint.Facet facet : ConstraintHelper.facetConstrains(constraints)) {
            parameters.addAll(ConstraintHelper.filterParameters(facet.constraints()));
        }
        return parameters;
    }

    private static List<Constraint.Parameter> filterParameters(List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList());
    }

    public static List<Constraint.Facet> facetConstrains(List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.Facet).map(c -> (Constraint.Facet)c).collect(Collectors.toList());
    }
}

