/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.dsl;

import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.lang.semantics.Assumption;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.Context;
import io.intino.tara.lang.semantics.DeclarationContext;
import io.intino.tara.lang.semantics.Documentation;
import io.intino.tara.lang.semantics.constraints.GlobalConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Tara
implements Language {
    static final String Root = "";
    private Map<String, Context> rulesCatalog = new HashMap<String, Context>();
    private Map<String, DeclarationContext> declarationsCatalog = new HashMap<String, DeclarationContext>();
    private List<String> lexicon = new ArrayList<String>();

    protected RuleTransaction def(String qualifiedName) {
        return context -> this.rulesCatalog.put(qualifiedName, context);
    }

    protected void declare(String qualifiedName, List<String> types, String path) {
        this.declarationsCatalog.put(qualifiedName, new DeclarationContext(types, path));
    }

    protected Context context(String ... types) {
        return new Context(types, new GlobalConstraints().all());
    }

    @Override
    public Map<String, Context> catalog() {
        return this.rulesCatalog;
    }

    @Override
    public List<Constraint> constraints(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Collections.unmodifiableList(this.rulesCatalog.get(qualifiedName).constraints());
    }

    @Override
    public List<Assumption> assumptions(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Collections.unmodifiableList(this.rulesCatalog.get(qualifiedName).assumptions());
    }

    @Override
    public Map<String, DeclarationContext> instances() {
        return Collections.unmodifiableMap(this.declarationsCatalog);
    }

    @Override
    public Documentation doc(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return this.rulesCatalog.get(qualifiedName).doc();
    }

    @Override
    public List<String> types(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Arrays.asList(this.rulesCatalog.get(qualifiedName).types());
    }

    @Override
    public String[] lexicon() {
        if (!this.lexicon.isEmpty()) {
            return this.lexicon.toArray(new String[this.lexicon.size()]);
        }
        return this.calculateLexicon();
    }

    private String[] calculateLexicon() {
        this.lexicon.addAll(this.collectTokens());
        return this.lexicon.toArray(new String[this.lexicon.size()]);
    }

    private Collection<String> collectTokens() {
        Set<String> collect = this.rulesCatalog.keySet().stream().filter(qn -> !Resolver.shortType(qn).isEmpty()).map(t -> {
            String shortType = Resolver.shortType(t);
            return shortType.contains(":") ? shortType.substring(0, shortType.indexOf(":")) : shortType;
        }).collect(Collectors.toSet());
        for (Context context : this.rulesCatalog.values()) {
            collect.addAll(context.constraints().stream().filter(c -> c instanceof Constraint.Facet).map(c -> ((Constraint.Facet)c).type()).collect(Collectors.toSet()));
        }
        return collect;
    }

    public static interface RuleTransaction {
        public Context with(Context var1);
    }
}

