/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.Language;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.semantics.Constraint;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Resolver {
    private final Language language;

    public Resolver(Language language) {
        this.language = language;
    }

    public void resolve(Node node) {
        if (this.context(node) == null) {
            return;
        }
        this.resolveNode(node);
    }

    private void resolveNode(Node node) {
        this.resolve(this.context(node));
        List<Constraint> contextConstraints = this.contextConstraints(node);
        if (contextConstraints == null) {
            return;
        }
        for (Constraint constraint : this.components(contextConstraints)) {
            if (!this.checkComponentConstraint(node, constraint)) continue;
            return;
        }
    }

    private List<Constraint> contextConstraints(Node node) {
        List<Constraint> constraints;
        if (node == null || this.language == null) {
            return Collections.emptyList();
        }
        Node context = this.context(node);
        List<Constraint> list = constraints = context != null && context.type() != null ? this.language.constraints(context.type()) : null;
        if (constraints != null && this.contextNodeConstraints(constraints, node)) {
            return constraints;
        }
        constraints = this.findInFacets(node);
        return constraints;
    }

    private boolean contextNodeConstraints(List<Constraint> context, Node node) {
        for (Constraint constraint : context) {
            if (!(constraint instanceof Constraint.Component) || !Resolver.shortType(((Constraint.Component)constraint).type()).equals(node.type()) && !this.isOneOf((Constraint.Component)constraint, node.type())) continue;
            return true;
        }
        return false;
    }

    private List<Constraint.Component> components(List<Constraint> context) {
        return context.stream().filter(c -> c instanceof Constraint.Component).map(c -> (Constraint.Component)c).collect(Collectors.toList());
    }

    private boolean isOneOf(Constraint.Component allow, String type) {
        if (!(allow instanceof Constraint.OneOf)) {
            return false;
        }
        Constraint.OneOf oneOf = (Constraint.OneOf)allow;
        for (Constraint constraint : oneOf.components()) {
            if (!((Constraint.Component)constraint).type().endsWith("." + type)) continue;
            return true;
        }
        return false;
    }

    private List<Constraint> findInFacets(Node node) {
        Node context = this.context(node);
        for (String type : context.secondaryTypes()) {
            List<Constraint> constraints = this.language.constraints(type.contains(":") ? type : type + ":" + context.type().replace(".", ":"));
            if (constraints == null || !this.contextNodeConstraints(constraints, node)) continue;
            return constraints;
        }
        return null;
    }

    private boolean checkComponentConstraint(Node node, Constraint constraint) {
        if (!(constraint instanceof Constraint.Component)) {
            return false;
        }
        if (constraint instanceof Constraint.OneOf) {
            return this.checkAllowOneOf(node, constraint);
        }
        return this.checkAsComponent(node, (Constraint.Component)constraint);
    }

    private boolean checkAsComponent(Node node, Constraint.Component allow) {
        String absoluteType = allow.type();
        if (node.type() != null && Resolver.shortType(node.type()).equals(Resolver.shortType(absoluteType))) {
            node.type(absoluteType);
            node.metaTypes(this.language.types(absoluteType));
            return true;
        }
        return false;
    }

    private boolean checkAllowOneOf(Node node, Constraint allow) {
        for (Constraint constraint : ((Constraint.OneOf)allow).components()) {
            String absoluteType = ((Constraint.Component)constraint).type();
            if (node.type() == null || !Resolver.shortType(node.type()).equals(Resolver.shortType(absoluteType))) continue;
            node.type(absoluteType);
            return true;
        }
        return false;
    }

    public Node context(Node node) {
        if (node == null) {
            return null;
        }
        return node.container();
    }

    public static String shortType(String absoluteType) {
        return absoluteType.contains(".") ? absoluteType.substring(absoluteType.lastIndexOf(46) + 1) : absoluteType;
    }
}

