/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.sourceunit;

import io.intino.builder.CompilerConfiguration;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.operation.sourceunit.SourceUnitCollectionOperation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class UnifyModelOperation
extends SourceUnitCollectionOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;
    private final CompilerConfiguration conf;

    public UnifyModelOperation(CompilationUnit unit) {
        this.unit = unit;
        this.conf = unit.configuration();
    }

    @Override
    public void call(Collection<SourceUnit> sources) {
        try {
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:Tarac: Merging to global models");
            }
            this.unit.model(this.merge(sources));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error merging sources representations: " + e.getMessage(), e);
        }
    }

    public Model merge(Collection<SourceUnit> sources) {
        Model model = new Model(this.uri(sources));
        model.languageName(this.conf.dsl().artifactId());
        model.setResourcesRoot(this.conf.resDirectory());
        sources.forEach(unit -> unit.model().mograms().forEach(c -> model.add((Element)c, unit.model().rulesOf((Element)c))));
        model.constraints(sources.stream().flatMap(u -> u.model().constraints().stream()).collect(Collectors.toList()));
        for (Mogram mogram : model.mograms()) {
            mogram.container((ElementContainer)model);
        }
        return model;
    }

    private URI uri(Collection<SourceUnit> sources) {
        return URI.create((String)(this.conf.project() != null ? this.conf.project() + "." + this.conf.dsl().outDsl() : this.getPresentableName(sources)));
    }

    private String getPresentableName(Collection<SourceUnit> sources) {
        String name = new File(sources.iterator().next().uri()).getName();
        return name.substring(0, name.lastIndexOf("."));
    }
}

