/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.sourceunit;

import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;
import io.intino.tara.builder.core.errorcollection.message.Message;
import io.intino.tara.builder.core.operation.sourceunit.SourceUnitOperation;
import io.intino.tara.language.grammar.SyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModelGenerationOperation
extends SourceUnitOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final ErrorCollector errorCollector;
    private final CompilationUnit unit;

    public ModelGenerationOperation(CompilationUnit unit) {
        this.unit = unit;
        this.errorCollector = unit.getErrorCollector();
    }

    @Override
    public void call(SourceUnit source) {
        try {
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:Converting " + String.valueOf(source.uri()));
            }
            source.importData();
            this.errorCollector.failIfErrors();
        }
        catch (SyntaxException e) {
            LOG.log(Level.SEVERE, "Error during conversion: " + e.getMessage());
            this.errorCollector.addError(Message.create(e.getMessage(), source));
        }
    }
}

