/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.setup;

import io.intino.builder.CompilerConfiguration;
import io.intino.tara.Language;
import io.intino.tara.builder.LanguageLoader;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.operation.setup.SetupOperation;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.dependencyresolution.DependencyResolver;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class SetupConfigurationOperation
extends SetupOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilerConfiguration configuration;
    private final CompilationUnit unit;
    private final String localRepo;

    public SetupConfigurationOperation(CompilationUnit unit) {
        this.configuration = unit.configuration();
        this.unit = unit;
        this.localRepo = this.configuration.localRepository().getAbsolutePath();
    }

    @Override
    public void call() throws CompilationFailedException {
        try {
            Language language = this.loadLanguage();
            DependencyResolver resolver = new DependencyResolver((Model)language.model(), null, null, null, null, null);
            resolver.resolve();
            this.unit.setLanguage(language);
            this.configuration.dsl().generationPackage(this.generationPackage());
        }
        catch (TaraException e) {
            LOG.severe(e.getMessage());
            this.unit.getErrorCollector().addException(e, null);
        }
        catch (DependencyException e) {
            LOG.severe(e.getMessage());
        }
    }

    private String generationPackage() {
        return this.generationPackage(LanguageLoader.getLanguagePath(this.configuration.dsl().groupId(), this.configuration.dsl().artifactId(), this.configuration.dsl().version(), this.localRepo));
    }

    private Language loadLanguage() throws TaraException {
        return LanguageLoader.load(this.configuration.dsl().groupId(), this.configuration.dsl().artifactId(), this.configuration.dsl().version(), this.localRepo);
    }

    String generationPackage(File language) {
        String string;
        String name = this.configuration.dsl().artifactId();
        if (language.isDirectory() || !language.exists()) {
            return name;
        }
        JarFile jarFile = new JarFile(language);
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes tara = manifest.getAttributes("tara");
            string = tara == null ? name : tara.getValue("generation.package".replace(".", "-"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
                return null;
            }
        }
        jarFile.close();
        return string;
    }
}

