/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.builder.CompilerConfiguration;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.errorcollection.message.Message;
import io.intino.tara.builder.core.errorcollection.message.WarningMessage;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticFatalException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Element;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.processors.SemanticAnalyzer;
import io.intino.tara.processors.model.Model;
import java.util.Collection;
import java.util.logging.Logger;

public class SemanticAnalysisOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getLogger(SemanticAnalysisOperation.class.getName());
    private final CompilerConfiguration conf;

    public SemanticAnalysisOperation(CompilationUnit unit) {
        super(unit);
        this.conf = unit.configuration();
    }

    @Override
    public void call(Model model) {
        try {
            if (this.conf.isVerbose()) {
                this.unit.out().println("@#$%@# Presentable:[" + this.conf.module() + " - " + this.unit.configuration().dsl().outDsl() + "] Analyzing semantic...");
            }
            new SemanticAnalyzer((MogramRoot)model, this.unit.language()).analyze();
        }
        catch (SemanticFatalException e) {
            this.semanticErrors(e);
        }
    }

    private void semanticErrors(SemanticFatalException fatal) {
        for (SemanticException e : fatal.exceptions()) {
            Element[] origins = e.origin();
            if (origins == null || origins.length == 0) {
                return;
            }
            SourceUnit sourceFromFile = this.getSourceFromFile(this.unit.getSourceUnits().values(), origins[0]);
            SemanticException semanticException = new SemanticException(e.getIssue());
            for (Element element : origins) {
                if (e.level() == SemanticIssue.Level.ERROR || e.level() == SemanticIssue.Level.RECOVERABLE_ERROR) {
                    this.unit.getErrorCollector().addError(Message.create(semanticException, sourceFromFile));
                    continue;
                }
                if (e.level() != SemanticIssue.Level.WARNING) continue;
                this.unit.getErrorCollector().addWarning(new WarningMessage(1, e.getMessage(), sourceFromFile, element != null ? element.line() : -1, element != null ? 0 : -1));
            }
        }
    }

    public void error(TaraException e) {
        LOG.severe(e.getMessage());
        throw new CompilationFailedException(this.unit.getPhase(), this.unit, e);
    }

    private SourceUnit getSourceFromFile(Collection<SourceUnit> values, Element origin) {
        if (origin == null) {
            return null;
        }
        for (SourceUnit value : values) {
            if (!value.uri().equals(origin.source())) continue;
            return value;
        }
        return null;
    }
}

