/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.message.Message;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.model.Element;
import io.intino.tara.model.Metric;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MetricResolutionOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();

    public MetricResolutionOperation(CompilationUnit unit) {
        super(unit);
    }

    @Override
    public void call(Model model) throws CompilationFailedException {
        try {
            this.resolve(model);
        }
        catch (DependencyException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(Message.create(e, this.unit.getSourceUnits().get(e.getElement().source())), true);
        }
    }

    public void resolve(Model model) throws DependencyException {
        for (Mogram mogram : model.components()) {
            this.resolve(mogram);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        this.resolveMeasures(mogram.parameters());
        this.resolveVariableMetrics(mogram.properties());
        for (Mogram component : mogram.components()) {
            this.resolve(component);
        }
    }

    private void resolveVariableMetrics(List<Property> variables) throws DependencyException {
        for (Property variable : variables) {
            if (!(variable.rules() instanceof PropertyCustomRule) || !((PropertyCustomRule)variable.rules()).isMetric() || variable.metric() == null) continue;
            PropertyCustomRule rule = (PropertyCustomRule)variable.rules();
            Metric metric = this.findMetric(rule.loadedClass(), variable.metric());
            if (metric == null) {
                throw new DependencyException("Metric not found", (Element)variable, new String[0]);
            }
            variable.values(variable.values().stream().map(arg_0 -> ((Metric)metric).value(arg_0)).collect(Collectors.toList()));
        }
    }

    private void resolveMeasures(List<PropertyDescription> parameters) throws DependencyException {
        for (PropertyDescription parameter : parameters) {
            if (!(parameter.rules() instanceof Metric) || parameter.metric() == null) continue;
            Metric metric = this.findMetric(parameter.rules().getClass(), parameter.metric());
            if (metric == null) {
                throw new DependencyException("Metric not found", (Element)parameter, new String[0]);
            }
            parameter.values(parameter.values().stream().map(arg_0 -> ((Metric)metric).value(arg_0)).collect(Collectors.toList()));
        }
    }

    private Metric findMetric(Class<?> aClass, String metric) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.isEnumConstant() || !field.getName().equals(metric)) continue;
            try {
                return (Metric)field.get(null);
            }
            catch (IllegalAccessException e) {
                LOG.severe(e.getMessage());
            }
        }
        return null;
    }
}

