/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.tara.builder.codegeneration.language.LanguageSerializer;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.model.Level;
import io.intino.tara.processors.model.Model;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class GenerateLanguageOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();

    public GenerateLanguageOperation(CompilationUnit unit) {
        super(unit);
    }

    @Override
    public void call(Model model) {
        try {
            if (model.mograms().stream().allMatch(m -> m.level().equals((Object)Level.M1))) {
                return;
            }
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:[" + this.unit.configuration().module() + " - " + this.unit.configuration().dsl().outDsl() + "] Generating language...");
            }
            if (this.unit.configuration().dsl().outDsl() == null) {
                throw new TaraException("No Dsl found");
            }
            File outputFile = new LanguageSerializer(this.unit.language(), this.unit.configuration(), model).serialize();
            this.unit.getErrorCollector().failIfErrors();
            this.unit.getSourceUnits().values().forEach(s -> this.unit.addOutputItems(Map.of(s.uri().getPath(), List.of(outputFile.getAbsolutePath()))));
        }
        catch (TaraException e) {
            LOG.log(java.util.logging.Level.SEVERE, "Error during language generation: " + e.getMessage() + "\n", e);
            throw new CompilationFailedException(8, this.unit, e);
        }
    }
}

