/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.language.LanguageModelAdapter;
import io.intino.tara.builder.codegeneration.language.LanguageTemplate;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.processors.model.Model;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class LanguageCreator {
    private final CompilerConfiguration conf;
    private final Model model;
    private final Language language;

    LanguageCreator(CompilerConfiguration conf, Model model, Language language) {
        this.conf = conf;
        this.model = model;
        this.language = language;
    }

    public String create() {
        LanguageTemplate template = new LanguageTemplate();
        Frame frame = this.createFrame(this.model);
        template.render(frame, this.formatters());
        return template.render(frame);
    }

    private Map<String, Formatter> formatters() {
        HashMap<String, Formatter> formatters = new HashMap<String, Formatter>();
        formatters.put("string", Format.string());
        formatters.put("path", value -> value.toString().replace(".", "/"));
        formatters.put("reference", Format.reference());
        formatters.put("toCamelCase", Format.toCamelCase());
        formatters.put("withDollar", Format.withDollar());
        return formatters;
    }

    private Frame createFrame(Model model) {
        return new LanguageModelAdapter(this.conf.groupId(), this.conf.dsl().outDsl(), this.conf.version(), Locale.getDefault(), this.language, this.conf.generationPackage()).adapt(model);
    }
}

