/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.model;

import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MogramReference
implements Mogram {
    private Mogram container;
    private MogramImpl destination;
    private String reference;
    private String file;
    private int line;
    private String doc;
    private List<Tag> flags = new ArrayList<Tag>();
    private List<Tag> annotations = new ArrayList<Tag>();
    private List<String> uses = new ArrayList<String>();
    private boolean has;
    private String language;

    public MogramReference(String reference) {
        this.reference = reference;
    }

    public MogramReference(MogramImpl destination) {
        this.destination = destination;
        this.reference = destination.qualifiedName();
    }

    public String getReference() {
        return this.reference;
    }

    public MogramImpl destination() {
        return this.destination;
    }

    public void destination(MogramImpl destination) {
        this.destination = destination;
    }

    public String layerQualifiedName() {
        return ((MogramImpl)this.container).layerQualifiedName() + "$" + this.destination.name();
    }

    public String name() {
        return this.destination != null ? this.destination.name() : "";
    }

    public void name(String name) {
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public String languageName() {
        return this.language;
    }

    public void languageName(String language) {
        this.language = language;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public String doc() {
        return this.doc;
    }

    public void doc(String doc) {
        this.doc = doc;
    }

    public boolean isSub() {
        return false;
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    public List<Mogram> subs() {
        return Collections.unmodifiableList(this.destination.subs());
    }

    public Mogram container() {
        return this.container;
    }

    public List<String> uses() {
        return this.uses;
    }

    public void container(Mogram container) {
        this.container = container;
    }

    public boolean isTerminal() {
        return this.is(Tag.Terminal);
    }

    public boolean isAbstract() {
        return this.is(Tag.Abstract);
    }

    public boolean isFacet() {
        return this.destination.isFacet();
    }

    public boolean isMetaFacet() {
        return this.destination.isMetaFacet();
    }

    public boolean is(Tag tag) {
        return this.destination.is(tag) || this.flags().contains(tag);
    }

    public boolean into(Tag tag) {
        return this.destination.into(tag) || this.annotations().contains(tag);
    }

    public List<Tag> annotations() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.destination.annotations());
        this.annotations.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        return Collections.unmodifiableList(tags);
    }

    public List<Tag> flags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.flags.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        if (this.isHas()) {
            tags.addAll(this.destination.flags());
        }
        return Collections.unmodifiableList(tags);
    }

    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    public void addUses(List<String> uses) {
        this.uses.addAll(uses);
    }

    public Mogram parent() {
        return null;
    }

    public String parentName() {
        return null;
    }

    public boolean isAnonymous() {
        return this.destination.isAnonymous();
    }

    public String qualifiedName() {
        return this.container.qualifiedName() + "." + this.destination.name();
    }

    public String type() {
        return this.destination.type();
    }

    public List<String> types() {
        return this.destination.types();
    }

    public List<String> secondaryTypes() {
        return this.destination.secondaryTypes();
    }

    public void type(String type) {
    }

    public void stashNodeName(String name) {
    }

    public Mogram resolve() {
        return this;
    }

    public boolean isReference() {
        return true;
    }

    public List<Parameter> parameters() {
        return Collections.emptyList();
    }

    public List<Mogram> siblings() {
        ArrayList components = new ArrayList(this.container.components());
        components.remove(this);
        return Collections.unmodifiableList(components);
    }

    public List<Mogram> components() {
        return Collections.unmodifiableList(this.destination.components());
    }

    public List<Rule> rulesOf(Mogram component) {
        return this.destination.rulesOf(component);
    }

    public boolean contains(Mogram mogramContainer) {
        return false;
    }

    public List<Variable> variables() {
        return Collections.unmodifiableList(this.destination.variables());
    }

    public List<Mogram> referenceComponents() {
        return Collections.unmodifiableList(this.destination.referenceComponents());
    }

    public Mogram targetOfReference() {
        return this.destination;
    }

    public List<Mogram> children() {
        return Collections.unmodifiableList(this.destination.children());
    }

    public List<Facet> appliedFacets() {
        return Collections.unmodifiableList(this.destination.appliedFacets());
    }

    public String toString() {
        return this.destination != null ? this.qualifiedName() : this.reference;
    }
}

