/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.errorcollection;

import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.semantics.MessageProvider;

public class DependencyException
extends TaraException {
    private final String message;
    private final transient Element element;
    private final String[] parameters;
    private final int line;

    public DependencyException(String message, Element element, String ... parameters) {
        this.message = message;
        this.element = element;
        this.parameters = parameters;
        this.line = element != null ? element.line() : -1;
    }

    @Override
    public String getMessage() {
        String elementReference = this.element != null && this.element instanceof MogramImpl ? ((Mogram)this.element).qualifiedName() : this.getElement(this.element);
        return "Dependency resolution error in " + elementReference + "; " + this.getCompleteMessage() + " @ line " + this.line + ", column 1.";
    }

    private String getElement(Element element) {
        if (element == null) {
            return "";
        }
        if (element instanceof Variable) {
            return "variable " + element;
        }
        if (element instanceof Parameter) {
            return "parameter";
        }
        return element.toString();
    }

    public Element getElement() {
        return this.element;
    }

    public int getLine() {
        return this.line;
    }

    private String getCompleteMessage() {
        return MessageProvider.message((String)this.message, (Object[])this.parameters);
    }
}

