/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core;

import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.semantic.LanguageLoader;
import io.intino.tara.builder.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CompilerConfiguration
implements Cloneable {
    public static final String REPOSITORY = "repository";
    private static final Logger LOG = Logger.getGlobal();
    private int warningLevel;
    private String sourceEncoding;
    private String project;
    private String module;
    private File outDirectory;
    private boolean debug;
    private final Locale languageForCodeGeneration = Locale.ENGLISH;
    private final List<File> sourceDirectories = new ArrayList<File>();
    private File resourcesDirectory;
    private File semanticRulesLib;
    private List<Integer> excludedPhases = new ArrayList<Integer>();
    private String groupID;
    private String artifactID;
    private String version;
    private final ModelConfiguration model;
    private boolean verbose;
    private File tempDirectory;
    private File languagesRepository = new File(System.getProperty("user.home") + "/.m2" + File.separator + "repository");
    private boolean test;
    private String workingPackage;
    private PrintStream out = System.out;
    private File workspaceDirectory;

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setDebug(false);
        String encoding = System.getProperty("file.encoding", "UTF8");
        encoding = System.getProperty("tara.source.encoding", encoding);
        this.sourceEncoding(encoding);
        this.model = new ModelConfiguration();
        try {
            this.tempDirectory = Files.createTempDirectory("_tara_", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            LOG.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String sourceEncoding() {
        return this.sourceEncoding;
    }

    public void sourceEncoding(String encoding) {
        this.sourceEncoding = encoding == null ? "UTF8" : encoding;
    }

    public File getOutDirectory() {
        return this.outDirectory;
    }

    public void setOutDirectory(File directory) {
        if (directory != null) {
            this.outDirectory = directory;
            this.outDirectory.mkdirs();
        } else {
            this.outDirectory = null;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public File languagesRepository() {
        return this.languagesRepository;
    }

    public void languagesRepository(File languagesRepository) {
        this.languagesRepository = languagesRepository;
    }

    public String groupId() {
        return this.groupID;
    }

    public void groupId(String groupID) {
        this.groupID = groupID;
    }

    public String artifactId() {
        return this.artifactID;
    }

    public void artifactId(String artifactID) {
        this.artifactID = artifactID;
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
        this.model.outDslVersion(version);
    }

    public void workingPackage(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    public String workingPackage() {
        return this.workingPackage == null || this.workingPackage.isEmpty() ? this.model.outDsl() : this.workingPackage;
    }

    public String dslGroupId() {
        return "tara.dsl";
    }

    public File resourcesDirectory() {
        return this.resourcesDirectory;
    }

    public void setResourcesDirectory(File resourcesDirectory) {
        this.resourcesDirectory = resourcesDirectory;
    }

    public void cleanTemp() {
        FileSystemUtils.removeDir(this.tempDirectory);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Locale getLocale() {
        return this.languageForCodeGeneration;
    }

    public File getSemanticRulesLib() {
        return new File(io.intino.tara.Language.class.getProtectionDomain().getCodeSource().getLocation().getFile());
    }

    public void language(String name, String version) {
        this.model.language(new Language(name, version));
    }

    public void language(io.intino.tara.Language taraLanguage) {
        this.model.language(new Language(taraLanguage));
    }

    public ModelConfiguration model() {
        return this.model;
    }

    List<Integer> getExcludedPhases() {
        return this.excludedPhases;
    }

    public void setExcludedPhases(List<Integer> excludedPhases) {
        this.excludedPhases = excludedPhases;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<File> sourceDirectories() {
        return this.sourceDirectories;
    }

    public void setWorkspaceDirectory(File workspaceDirectory) {
        this.workspaceDirectory = new File(workspaceDirectory, "tara");
    }

    public File getImportsCache() {
        return new File(this.workspaceDirectory, this.module + ".json");
    }

    public File rulesDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String rulesPackage;
            File file = new File(sourceDirectory, rulesPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "rules");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File functionsDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String functionsPackage;
            File file = new File(sourceDirectory, functionsPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "functions");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public CompilerConfiguration clone() {
        try {
            return (CompilerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    public PrintStream out() {
        return this.out;
    }

    public void out(PrintStream out) {
        this.out = out;
    }

    private static void configureLog() {
        Logger.getGlobal().setLevel(java.util.logging.Level.INFO);
        LOG.setUseParentHandlers(false);
        for (Handler handler : LOG.getHandlers()) {
            LOG.removeHandler(handler);
        }
        StreamHandler errorHandler = new StreamHandler(System.err, new SimpleFormatter());
        errorHandler.setLevel(java.util.logging.Level.WARNING);
        LOG.addHandler(errorHandler);
        StreamHandler infoHandler = new StreamHandler(System.out, new SimpleFormatter());
        infoHandler.setLevel(java.util.logging.Level.INFO);
        LOG.addHandler(infoHandler);
    }

    static {
        CompilerConfiguration.configureLog();
    }

    public class ModelConfiguration {
        private Language language;
        private String outLanguageName;
        private String outLanguageVersion;
        private Level level;

        public Language language() {
            return this.language;
        }

        public void language(Language language) {
            this.language = language;
        }

        public void outDsl(String name) {
            this.outLanguageName = name;
        }

        public void outDslVersion(String version) {
            this.outLanguageVersion = version;
        }

        public String outDsl() {
            return this.outLanguageName;
        }

        public String outDslVersion() {
            return this.outLanguageVersion;
        }

        public void level(Level level) {
            this.level = level;
        }

        public Level level() {
            return this.level;
        }
    }

    public class Language {
        io.intino.tara.Language language;
        String name;
        String version;
        String generationPackage;

        public Language(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public Language(io.intino.tara.Language language) {
            this.language = language;
            this.name = this.language.languageName();
        }

        public io.intino.tara.Language get() {
            return this.language == null ? (this.language = this.loadLanguage()) : this.language;
        }

        public String name() {
            return this.language == null ? this.name : this.language.languageName();
        }

        public String version() {
            return this.version;
        }

        public void version(String version) {
            this.version = version;
        }

        public String generationPackage() {
            return this.generationPackage;
        }

        void generationPackage(File language) {
            if (language.isDirectory() || !language.exists()) {
                this.generationPackage = this.name;
            } else {
                try (JarFile jarFile = new JarFile(language);){
                    Manifest manifest = jarFile.getManifest();
                    Attributes tara = manifest.getAttributes("tara");
                    this.generationPackage = tara == null ? this.name : tara.getValue("generation.package".replace(".", "-"));
                }
                catch (IOException e) {
                    LOG.severe(e.getMessage());
                }
            }
        }

        private io.intino.tara.Language loadLanguage() {
            try {
                io.intino.tara.Language language = LanguageLoader.load(this.name, this.version, CompilerConfiguration.this.languagesRepository().getAbsolutePath());
                this.generationPackage(LanguageLoader.getLanguagePath(this.name, this.version, CompilerConfiguration.this.languagesRepository().getAbsolutePath()));
                return language;
            }
            catch (TaraException | NoClassDefFoundError e) {
                LOG.info("Language " + this.name() + " cannot be load");
                return null;
            }
        }
    }

    public static enum Level {
        Model,
        MetaModel,
        MetaMetaModel;


        public int compareLevelWith(Level type) {
            return type.ordinal() - this.ordinal();
        }
    }
}

