/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core;

import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.ModelResolutionOperation;
import io.intino.tara.builder.core.ProcessingUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.operation.Operation;
import io.intino.tara.builder.core.operation.model.GenerateLanguageOperation;
import io.intino.tara.builder.core.operation.model.MetricResolutionOperation;
import io.intino.tara.builder.core.operation.model.ModelCollectionOperation;
import io.intino.tara.builder.core.operation.model.ModelDependencyResolutionOperation;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.core.operation.model.NativeTransformationOperation;
import io.intino.tara.builder.core.operation.model.SemanticAnalysisOperation;
import io.intino.tara.builder.core.operation.setup.SetupConfigurationOperation;
import io.intino.tara.builder.core.operation.setup.SetupOperation;
import io.intino.tara.builder.core.operation.sourceunit.MarkOperation;
import io.intino.tara.builder.core.operation.sourceunit.ModelGenerationOperation;
import io.intino.tara.builder.core.operation.sourceunit.ParseOperation;
import io.intino.tara.builder.core.operation.sourceunit.SourceUnitCollectionOperation;
import io.intino.tara.builder.core.operation.sourceunit.SourceUnitOperation;
import io.intino.tara.builder.core.operation.sourceunit.UnifyModelOperation;
import io.intino.tara.builder.model.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class CompilationUnit
extends ProcessingUnit {
    private final Map<String, SourceUnit> sourceUnits;
    private final Map<Language, Model> models = new HashMap<Language, Model>();
    private final LinkedList[] phaseOperations;
    private final Map<String, List<String>> outputItems = new HashMap<String, List<String>>();

    public CompilationUnit(CompilerConfiguration configuration) {
        super(configuration, null);
        this.sourceUnits = new HashMap<String, SourceUnit>();
        this.phaseOperations = new LinkedList[10];
        IntStream.range(0, this.phaseOperations.length).forEach(i -> {
            this.phaseOperations[i] = new LinkedList();
        });
        this.addBasePhaseOperations();
    }

    public static void cleanOut(CompilerConfiguration configuration) {
        String generationPackage = (configuration.workingPackage() == null ? configuration.getModule() : configuration.workingPackage()).replace(".", File.separator);
        File out = new File(configuration.getOutDirectory(), generationPackage.toLowerCase());
    }

    private void addBasePhaseOperations() {
        this.addPhaseOperation(new SetupConfigurationOperation(this), 1);
        this.addPhaseOperation(new ParseOperation(this), 2);
        this.addPhaseOperation(new ModelGenerationOperation(this), 3);
        this.addPhaseOperation(new UnifyModelOperation(this), 3);
        this.addPhaseOperation(new ModelDependencyResolutionOperation(this), 4);
        this.addPhaseOperation(new ModelResolutionOperation(this), 5);
        this.addPhaseOperation(new SemanticAnalysisOperation(this), 6);
        this.addPhaseOperation(new MetricResolutionOperation(this), 7);
        this.addPhaseOperation(new NativeTransformationOperation(this), 7);
        this.addPhaseOperation(new GenerateLanguageOperation(this), 9);
    }

    public void addPhaseOperation(Operation operation, int phase) {
        if (phase < 1 || phase > 9) {
            throw new IllegalArgumentException("phase " + phase + " is unknown");
        }
        if (!this.isExcludedPhase(phase)) {
            this.phaseOperations[phase].add(operation);
        }
    }

    private boolean isExcludedPhase(int phase) {
        return this.configuration.getExcludedPhases().contains(phase);
    }

    public void addOutputItems(Map<String, List<String>> paths) {
        for (String source : paths.keySet()) {
            this.outputItems.putIfAbsent(source, new ArrayList());
            this.outputItems.get(source).addAll((Collection<String>)paths.get(source));
        }
    }

    public void addSource(SourceUnit source) {
        String name = source.getName();
        for (SourceUnit su : this.sourceUnits.values()) {
            if (!name.equals(su.getName())) continue;
            return;
        }
        this.sourceUnits.put(name, source);
    }

    public Map<String, SourceUnit> getSourceUnits() {
        return this.sourceUnits;
    }

    public void compile() throws CompilationFailedException {
        this.compile(10);
    }

    private void compile(int throughPhase) throws CompilationFailedException {
        this.gotoPhase(1);
        while (Math.min(throughPhase, 9) >= this.phase && this.phase <= 9) {
            this.processPhaseOperations(this.phase);
            this.completePhase();
            this.nextPhase();
            this.applyToSourceUnits(new MarkOperation(this));
        }
        this.errorCollector.failIfErrors();
    }

    private void applyToSourceUnits(SourceUnitOperation mark) throws CompilationFailedException {
        for (String name : this.sourceUnits.keySet()) {
            SourceUnit source = this.sourceUnits.get(name);
            if (source.phase >= this.phase && (source.phase != this.phase || source.phaseComplete)) continue;
            mark.call(source);
        }
        this.getErrorCollector().failIfErrors();
    }

    private void processPhaseOperations(int ph) {
        LinkedList ops = this.phaseOperations[ph];
        ops.forEach(this::doPhaseOperation);
    }

    private void doPhaseOperation(Operation operation) {
        if (operation instanceof SourceUnitOperation) {
            this.applyToSourceUnits((SourceUnitOperation)operation);
        } else if (operation instanceof SourceUnitCollectionOperation) {
            ((SourceUnitCollectionOperation)operation).call(this.sourceUnits.values());
        } else if (operation instanceof ModelCollectionOperation) {
            ((ModelCollectionOperation)operation).call(this.models.values());
        } else if (operation instanceof ModelOperation) {
            this.models.values().forEach(((ModelOperation)operation)::call);
        } else if (operation instanceof SetupOperation) {
            ((SetupOperation)operation).call();
        }
    }

    public Map<Language, Model> models() {
        return this.models;
    }

    public void addModel(Language language, Model model) {
        this.models.put(language, model);
    }

    public Map<String, List<String>> getOutputItems() {
        return this.outputItems;
    }
}

