/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.calendars.StandardWeekCalendar;
import io.intino.sumus.reporting.calendars.WeekCalendar;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;

public enum Scale {
    Day,
    Week,
    Month,
    Quarter,
    Year;

    public static WeekCalendar WeekCalendar;

    public static Scale of(io.intino.alexandria.Scale scale) {
        if (scale == io.intino.alexandria.Scale.Year) {
            return Year;
        }
        if (scale == io.intino.alexandria.Scale.Month) {
            return Month;
        }
        return Day;
    }

    public List<LocalDate> dates(LocalDate to) {
        return this.startDate(to).datesUntil(to.plusDays(1L)).collect(Collectors.toList());
    }

    public LocalDate startDate(Timetag timetag) {
        return this.startDate(timetag.datetime().toLocalDate());
    }

    public LocalDate startDate(LocalDate date) {
        if (this == Week) {
            return WeekCalendar.startDate(date);
        }
        if (this == Month) {
            return date.withDayOfMonth(1);
        }
        if (this == Quarter) {
            return date.with(date.getMonth().firstMonthOfQuarter()).withDayOfMonth(1);
        }
        if (this == Year) {
            return date.withDayOfYear(1);
        }
        return date;
    }

    public LocalDate endDate(Timetag timetag) {
        return this.endDate(timetag.datetime().toLocalDate());
    }

    public LocalDate endDate(LocalDate date) {
        if (this == Week) {
            return WeekCalendar.endDate(date);
        }
        if (this == Month) {
            return this.startDate(date).plusMonths(1L).minusDays(1L);
        }
        if (this == Quarter) {
            return this.startDate(date).plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
        }
        if (this == Year) {
            return this.startDate(date).plusYears(1L).minusDays(1L);
        }
        return date;
    }

    public String format(Timetag timetag) {
        return this.format(timetag.datetime().toLocalDate());
    }

    public String format(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        }
        if (this == Week) {
            return WeekCalendar.format(date);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("MM/yyyy"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("yyyy-'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }

    public String timetag(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if (this == Week) {
            return WeekCalendar.timetag(date);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("yyyy'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }

    public String label(LocalDate date) {
        if (this == Day) {
            return date.format(DateTimeFormatter.ofPattern("dd"));
        }
        if (this == Week) {
            return WeekCalendar.label(date);
        }
        if (this == Month) {
            return date.format(DateTimeFormatter.ofPattern("MM"));
        }
        if (this == Quarter) {
            return date.format(DateTimeFormatter.ofPattern("'Q'q"));
        }
        if (this == Year) {
            return date.format(DateTimeFormatter.ofPattern("yyyy"));
        }
        return "";
    }

    static {
        WeekCalendar = new StandardWeekCalendar();
    }
}

