/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.sumus.reporting.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NodeLoader {
    private final Map<String, Node> nodeMap = new HashMap<String, Node>();
    private final String dimension;
    private final Set<String> names;

    public NodeLoader(String dimension, Set<String> names) {
        this.dimension = dimension;
        this.names = names;
    }

    public List<Node> nodes() {
        for (String name : this.names) {
            this.getOrCreate(name);
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.nodeMap.values());
        nodes.add(this.globalNode(nodes));
        return nodes;
    }

    private Node getOrCreate(String name) {
        if (!this.nodeMap.containsKey(name) && this.names.contains(name)) {
            this.nodeMap.put(name, this.nodeOf(name));
        }
        return this.nodeMap.get(name);
    }

    private Node nodeOf(final String name) {
        return new Node(){

            @Override
            public String id() {
                return name;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String dimension() {
                return NodeLoader.this.dimension;
            }

            @Override
            public Node parent() {
                if (!name.contains(".")) {
                    return null;
                }
                return NodeLoader.this.getOrCreate(name.substring(0, name.lastIndexOf(46)));
            }

            @Override
            public List<Node> children() {
                return NodeLoader.this.names.stream().filter(o -> o.startsWith(name + ".")).filter(o -> !o.replace(name + ".", "").contains(".")).map(n -> NodeLoader.this.getOrCreate((String)n)).collect(Collectors.toList());
            }
        };
    }

    private Node globalNode(final List<Node> nodes) {
        return new Node(){

            @Override
            public String id() {
                return "_All";
            }

            @Override
            public String name() {
                return "";
            }

            @Override
            public String dimension() {
                return NodeLoader.this.dimension;
            }

            @Override
            public Node parent() {
                return null;
            }

            @Override
            public List<Node> children() {
                return nodes.stream().filter(n -> n.parent() == null).filter(n -> !n.id().equals("_All")).collect(Collectors.toList());
            }
        };
    }
}

