/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.model.CustomIndicator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormulaCalculator {
    private final Map<String, String> formulas;
    private final Map<String, Double> variables;

    public FormulaCalculator(List<CustomIndicator> customIndicators, List<? extends Cube.Indicator> cubeIndicators) {
        this(customIndicators.stream().collect(Collectors.toMap(CustomIndicator::name, CustomIndicator::formula)), cubeIndicators.stream().collect(Collectors.toMap(Cube.Indicator::name, CubesHelper::doubleValueOf)));
    }

    public FormulaCalculator(Map<String, String> formulas, Map<String, Double> variables) {
        this.formulas = formulas;
        this.variables = variables;
    }

    public Double value(String name) throws FormulaException {
        Double value = this.variables.getOrDefault(name, this.getDouble(name));
        if (value != null) {
            return value;
        }
        String formula = this.formulas.get(name);
        if (formula == null) {
            throw new FormulaException(name + " is not a number, variable nor formula");
        }
        String[] split = formula.split(" ");
        if (split.length != 3) {
            throw new FormulaException("Invalid formula \"" + formula + "\". It must be separate with spaces");
        }
        String symbol = split[1];
        Operation operation = Operation.of(symbol);
        if (operation == null) {
            throw new FormulaException("Unknown operation symbol \"" + symbol + "\"");
        }
        return operation.evaluate(this.value(split[0].trim()), this.value(split[2].trim()));
    }

    private Double getDouble(String name) {
        try {
            return Double.parseDouble(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static class FormulaException
    extends Exception {
        public FormulaException(String message) {
            super(message);
        }
    }

    static enum Operation {
        Plus("+"),
        Minus("-"),
        Multiply("*"),
        Divide("/");

        private final String symbol;

        private Operation(String symbol) {
            this.symbol = symbol;
        }

        public Double evaluate(Double operand1, Double operand2) {
            switch (this) {
                case Plus: {
                    return operand1 + operand2;
                }
                case Minus: {
                    return operand1 - operand2;
                }
                case Divide: {
                    return operand1 / operand2;
                }
                case Multiply: {
                    return operand1 * operand2;
                }
            }
            return null;
        }

        public static Operation of(String symbol) {
            return Arrays.stream(Operation.values()).filter(v -> v.symbol.equals(symbol)).findFirst().orElse(null);
        }
    }
}

