/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.schemas.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViewConfig {
    private final String report;
    private final String ledger;
    private final String view;
    private EscapedOrUndefined dimension = new EscapedOrUndefined();
    private String dimension2;
    private EscapedOrUndefined nodeDimension;
    private String node;
    private String nodeID;
    private List<String> indicators = new ArrayList<String>();
    private List<String> filters = new ArrayList<String>();
    private List<ViewPlotLine> plotLines = new ArrayList<ViewPlotLine>();
    private EscapedOrUndefinedArray slices = new EscapedOrUndefinedArray();
    private EscapedOrUndefinedArray viewFilters = new EscapedOrUndefinedArray();
    private List<String> dateFilters = new ArrayList<String>();
    private ViewLabels labels = new ViewLabels();
    private boolean isNav = false;
    private boolean showDataLabels = false;

    public ViewConfig(String report, String ledger, String view) {
        this.report = report;
        this.ledger = ledger;
        this.view = view;
    }

    public ViewConfig dimension(String dimension) {
        this.dimension = new EscapedOrUndefined(dimension);
        return this;
    }

    public ViewConfig dimension2(String dimension2) {
        this.dimension2 = dimension2;
        return this;
    }

    public ViewConfig nodeDimension(String nodeDimension) {
        this.nodeDimension = new EscapedOrUndefined(nodeDimension);
        return this;
    }

    public ViewConfig node(String node) {
        this.node = node;
        return this;
    }

    public ViewConfig nodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    public ViewConfig indicators(List<String> indicators) {
        this.indicators = indicators;
        return this;
    }

    public ViewConfig filters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public ViewConfig plotLines(List<ViewPlotLine> plotLines) {
        this.plotLines = plotLines;
        return this;
    }

    public ViewConfig slices(List<String> slices) {
        this.slices = new EscapedOrUndefinedArray(slices);
        return this;
    }

    public ViewConfig viewFilters(List<String> viewFilters) {
        this.viewFilters = new EscapedOrUndefinedArray(viewFilters);
        return this;
    }

    public ViewConfig dateFilters(List<String> dateFilters) {
        this.dateFilters = dateFilters;
        return this;
    }

    public ViewConfig labels(ViewLabels labels) {
        this.labels = labels;
        return this;
    }

    public ViewConfig isNav(boolean nav) {
        this.isNav = nav;
        return this;
    }

    public ViewConfig showDataLabels(boolean show) {
        this.showDataLabels = show;
        return this;
    }

    public static class ViewPlotLine {
        private final String value;
        private String name;
        private String color;

        public ViewPlotLine(String value) {
            this.value = value;
        }

        public ViewPlotLine name(String name) {
            this.name = name;
            return this;
        }

        public ViewPlotLine color(String color) {
            this.color = color;
            return this;
        }
    }

    public static class ViewLabels {
        private final List<ViewLabel> labels = new ArrayList<ViewLabel>();

        public ViewLabels set(String key, String value) {
            this.labels.add(new ViewLabel(key, value));
            return this;
        }

        private static class ViewLabel {
            String key;
            String value;

            public ViewLabel(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    private static class EscapedOrUndefinedArray {
        private final List<String> values;

        public EscapedOrUndefinedArray() {
            this(Collections.emptyList());
        }

        public EscapedOrUndefinedArray(List<String> values) {
            this.values = values;
        }
    }

    private static class EscapedOrUndefined {
        private final String value;

        public EscapedOrUndefined() {
            this(null);
        }

        public EscapedOrUndefined(String value) {
            this.value = value;
        }
    }
}

