/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.builders.schemas.Table;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableBar
extends Table {
    final List<String> barAttributes;
    List<RowBar> rows = Collections.emptyList();
    double maxLength = 0.0;

    public TableBar(String id, String title, List<Table.Attribute> attributes, List<String> barAttributes) {
        super(id, title, attributes);
        this.barAttributes = barAttributes;
    }

    @Override
    public Table rows(List<Table.Row> rows) throws Table.TableChartException {
        for (Table.Row row : rows) {
            this.checkSizes(row);
        }
        this.maxLength = this.maxLength(rows);
        this.rows = rows.stream().map(r -> new RowBar((Table.Row)r, this.barsOf((Table.Row)r))).collect(Collectors.toList());
        return this;
    }

    private Double maxLength(List<Table.Row> rows) {
        double maxLenght = 0.0;
        for (Table.Row row : rows) {
            double rowLength = this.barAttributes.stream().map(a -> this.valueOf(row, (String)a)).filter(Objects::nonNull).mapToDouble(v -> v).sum();
            if (!(rowLength > maxLenght)) continue;
            maxLenght = rowLength;
        }
        return maxLenght;
    }

    private Double valueOf(Table.Row row, String indicator) {
        Table.Attribute attribute = this.attributeOf(indicator);
        if (attribute == null) {
            return null;
        }
        Table.Cell cell = row.cells.get(attribute.index());
        if (cell == null) {
            return null;
        }
        Object value = cell.value();
        return value instanceof Double ? Double.valueOf((Double)value) : null;
    }

    private Table.Attribute attributeOf(String id) {
        return this.attributes.stream().filter(a -> a.id().equalsIgnoreCase(id)).findFirst().orElse(null);
    }

    private List<RowBar.Bar> barsOf(Table.Row row) {
        return this.barAttributes.stream().map(indicator -> {
            Double value = this.valueOf(row, (String)indicator);
            if (value == null) {
                return null;
            }
            double width = this.maxLength != 0.0 ? value * 100.0 / this.maxLength : 0.0;
            return new RowBar.Bar((String)indicator, width);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class RowBar
    extends Table.Row {
        List<Bar> bars;

        public RowBar(Table.Row row, List<Bar> bars) {
            super(row.name);
            this.cells = row.cells;
            this.onMicrosite = row.onMicrosite;
            this.onClick = row.onClick;
            this.bars = bars;
        }

        private static class Bar {
            String name;
            double width;

            public Bar(String name, double width) {
                this.name = name;
                this.width = width;
            }
        }
    }
}

