/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.ColumnChartBuilder;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.schemas.ColumnChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StackedColumnChartBuilder
extends ColumnChartBuilder {
    public StackedColumnChartBuilder(Dashboard.Report report, Dashboard.Insight insight, MicrositeActionBuilder microsite) {
        super(report, insight, microsite);
    }

    @Override
    public String build(Cube cube, Node node) {
        return this.insight.dimensions().length == 2 ? this.buildStackedColumn(cube, node) : this.buildColumnChart(cube, node);
    }

    private String buildColumnChart(Cube cube, Node node) {
        return new ColumnChartBuilder(this.report, this.insight, this.microsite).build(cube, node);
    }

    private String buildStackedColumn(Cube cube, Node node) {
        return Renderer.render(this.stackedColumn(cube, node));
    }

    private ColumnChart stackedColumn(Cube cube, Node node) {
        String indicator = this.insight.indicators()[0];
        HashMap<String, ColumnChart.Serie> seriesMap = new HashMap<String, ColumnChart.Serie>();
        for (Slice categorySlice : this.categorySlices(cube, node)) {
            String category = categorySlice.toString();
            for (Slice seriesSlice : this.seriesSlices(cube, node)) {
                double value = this.valueOf(cube, categorySlice, seriesSlice, indicator);
                if (this.isInvalid(value)) continue;
                String serie = seriesSlice.toString();
                seriesMap.putIfAbsent(serie, new ColumnChart.Serie(serie));
                ((ColumnChart.Serie)seriesMap.get(serie)).addValue(category, value);
            }
        }
        ArrayList<ColumnChart.Serie> series = new ArrayList<ColumnChart.Serie>(seriesMap.values());
        return new ColumnChart(this.insight.id(), this.insight.label(), this.insight.order()).showDataLabels(this.insight.showDataLabels()).stacked(true).units(this.units(cube)).plotLines(this.plotLines()).series(series);
    }

    private List<Slice> categorySlices(Cube cube, Node node) {
        return this.slices(cube, node, this.insight.dimensions()[0]);
    }

    private List<Slice> seriesSlices(Cube cube, Node node) {
        return this.slices(cube, node, this.insight.dimensions()[1]);
    }

    private double valueOf(Cube cube, Slice slice1, Slice slice2, String indicator) {
        Cube.Cell cell = cube.cell(slice1 + "-" + slice2);
        return CubesHelper.doubleValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
    }

    private List<Slice> slices(Cube cube, Node node, String dimension) {
        return this.isNavigable(node, dimension) ? this.slices(cube, node) : this.slices(cube, dimension);
    }

    private List<Slice> slices(Cube cube, Node node) {
        return node.children().stream().map(Node::name).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(Objects::nonNull).flatMap(c -> c.slices().stream()).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    private List<Slice> slices(Cube cube, String dimension) {
        return cube.dimensions().stream().filter(d -> d.name().equalsIgnoreCase(dimension)).flatMap(d -> d.slices().stream()).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
    }

    private String units(Cube cube) {
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return "";
        }
        List units = cell.indicators().stream().map(Cube.Indicator::units).collect(Collectors.toList());
        if (units.isEmpty() || units.contains(null)) {
            return "";
        }
        String unit = (String)units.get(0);
        return units.stream().allMatch(unit::equalsIgnoreCase) ? unit : "";
    }
}

