/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.PieChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class PieChartBuilder
implements UIBuilder {
    private final Dashboard.Insight insight;
    private final Dashboard.Report report;
    private final MicrositeActionBuilder microsite;

    public PieChartBuilder(Dashboard.Report report, Dashboard.Insight insight, MicrositeActionBuilder microsite) {
        this.report = report;
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Node node) {
        PieChart pie = new PieChart(this.insight.id(), this.insight.label()).slices(this.pieSlices(cube, node));
        return Renderer.render(pie);
    }

    private List<PieChart.PieSlice> pieSlices(Cube cube, Node node) {
        List<PieChart.PieSlice> slices = this.insight.dimensions().length > 0 ? this.dimensionSlices(cube, node) : this.indicatorSlices(cube, node);
        return slices.stream().sorted(PieChart.PieSlice.sortMethodOf(this.insight.order())).limit(this.maxItems()).collect(Collectors.toList());
    }

    private List<PieChart.PieSlice> dimensionSlices(Cube cube, Node node) {
        String indicator = this.insight.indicators()[0];
        LinkedList<PieChart.PieSlice> pieSlices = new LinkedList<PieChart.PieSlice>();
        for (Slice slice : this.slices(cube)) {
            Cube.Cell cell = cube.cell(slice.name());
            if (cell == null) continue;
            String name = cell.toString();
            int value = CubesHelper.intValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
            if (name.isEmpty() || value == 0) continue;
            String label = this.insight.translate(name);
            pieSlices.add(new PieChart.PieSlice(label, value).onClick(this.onClickAction(node, cell)));
        }
        return pieSlices;
    }

    private List<PieChart.PieSlice> indicatorSlices(Cube cube, Node node) {
        LinkedList<PieChart.PieSlice> pieSlices = new LinkedList<PieChart.PieSlice>();
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return pieSlices;
        }
        for (String indicator : this.insight.indicators()) {
            int value = CubesHelper.intValueOf(CubesHelper.indicatorOf(this.report, cell, indicator));
            if (value == 0) continue;
            String label = this.insight.translate(indicator);
            pieSlices.add(new PieChart.PieSlice(label, value).onClick(this.onClickAction(node, cell)));
        }
        return pieSlices;
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.level()).stream()).collect(Collectors.toList());
    }

    private long maxItems() {
        return this.insight.maxItems() != null ? (long)this.insight.maxItems().intValue() : Integer.MAX_VALUE;
    }

    private int level() {
        return this.insight.level() != null ? this.insight.level() : 100;
    }

    private String onClickAction(Node node, Cube.Cell cell) {
        return this.microsite.action(node, cell.slices());
    }
}

