/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.alexandria.Timetag;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.MicrositeAction;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.model.Scale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MicrositeActionBuilder {
    private final Dashboard.Insight insight;
    private final Dashboard.Report report;
    private final Timetag timetag;
    private final Scale scale;

    public MicrositeActionBuilder(Dashboard.Insight insight, Dashboard.Report report, Timetag timetag, Scale scale) {
        this.insight = insight;
        this.report = report;
        this.timetag = timetag;
        this.scale = scale;
    }

    public String action(Node node, List<? extends Slice> slices) {
        return this.action(node, slices.toArray(new Slice[0]));
    }

    public String action(Node node, Slice ... slices) {
        List<String> filters = this.filters(node, slices);
        MicrositeAction action = new MicrositeAction(this.insight.ledger(), new Timetag(this.scale.startDate(this.timetag), this.timetag.scale()), this.timetag).filters(filters).dateFilters(this.dateFilters()).title(this.title()).subtitle(this.subtitle(filters));
        return Renderer.render(action);
    }

    private String title() {
        return this.report.name() + " " + this.scale.format(this.timetag);
    }

    private String subtitle(List<String> filters) {
        return filters.stream().map(f -> f.split(":")).filter(f -> ((String[])f).length > 1).map(f -> f[1]).collect(Collectors.joining(" - "));
    }

    private List<String> dateFilters() {
        return List.of(this.insight.dateFilters(this.timetag));
    }

    private List<String> filters(Node node, Slice ... slices) {
        ArrayList<String> filters = new ArrayList<String>();
        if (node.dimension() != null && !this.isSameDimension(node, slices)) {
            filters.add(node.filter());
        }
        filters.addAll(this.filters(slices));
        filters.addAll(this.insightFilters());
        Collections.addAll(filters, this.report.filters());
        return filters;
    }

    private List<String> filters(Slice ... slices) {
        return Arrays.stream(slices).map(slice -> slice.dimension().name() + ":" + slice.name()).collect(Collectors.toList());
    }

    private List<String> insightFilters() {
        return Arrays.stream(this.insight.filters(this.timetag)).collect(Collectors.toList());
    }

    private boolean isSameDimension(Node node, Slice ... slices) {
        return Arrays.stream(slices).anyMatch(s -> this.isSameDimension(node, (Slice)s));
    }

    private boolean isSameDimension(Node node, Slice slice) {
        return node.dimension().equalsIgnoreCase(slice.dimension().name());
    }
}

