/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.ColumnChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.insights.ColumnInsight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColumnChartBuilder
implements UIBuilder {
    private static final int MaxLevel = 100;
    protected final ColumnInsight insight;
    protected final Dashboard.Report report;
    protected final MicrositeActionBuilder microsite;

    public ColumnChartBuilder(Dashboard.Report report, Dashboard.Insight insight, MicrositeActionBuilder microsite) {
        this.report = report;
        this.insight = new ColumnInsight(insight);
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Node node) {
        ColumnChart column = this.insight.dimensions().length > 0 ? this.indicatorSeries(cube, node) : this.sliceSeries(cube, node);
        return Renderer.render(column);
    }

    private ColumnChart indicatorSeries(Cube cube, Node node) {
        HashMap<String, ColumnChart.Serie> seriesMap = new HashMap<String, ColumnChart.Serie>();
        ArrayList<ColumnChart.CategoryAction> actions = new ArrayList<ColumnChart.CategoryAction>();
        for (Cube.Cell cell : this.cells(cube, node)) {
            if (cell == null || cell.toString().isEmpty()) continue;
            String category = this.insight.translate(cell.toString());
            for (String indicator : this.insight.indicators()) {
                double value = this.valueOf(cell, indicator);
                if (this.isInvalid(value)) continue;
                seriesMap.putIfAbsent(indicator, new ColumnChart.Serie(indicator));
                ((ColumnChart.Serie)seriesMap.get(indicator)).addValue(category, value);
            }
            actions.add(new ColumnChart.CategoryAction(category, this.onClickAction(node, cell)));
        }
        return new ColumnChart(this.insight.id(), this.insight.label(), this.insight.order()).showDataLabels(this.insight.showDataLabels()).units(this.units(cube)).stacked(false).plotLines(this.plotLines()).series(new ArrayList<ColumnChart.Serie>(seriesMap.values())).onClick(actions);
    }

    private ColumnChart sliceSeries(Cube cube, Node node) {
        ArrayList<ColumnChart.Serie> series = new ArrayList<ColumnChart.Serie>();
        for (Cube.Cell cell : this.cells(cube, node)) {
            if (cell == null) continue;
            ColumnChart.Serie serie = new ColumnChart.Serie(this.insight.translate(cell.toString())).onClick(this.onClickAction(node, cell));
            for (String indicator : this.insight.indicators()) {
                double value = this.valueOf(cell, indicator);
                if (this.isInvalid(value)) continue;
                serie.addValue(indicator, value);
            }
            if (this.isInvalid(serie)) continue;
            series.add(serie);
        }
        return new ColumnChart(this.insight.id(), this.insight.label(), this.insight.order()).units(this.units(cube)).plotLines(this.plotLines()).series(series);
    }

    private double valueOf(Cube.Cell cell, String i) {
        Cube.Indicator indicator = CubesHelper.indicatorOf(this.report, cell, i);
        return FormatHelper.round(CubesHelper.doubleValueOf(indicator), 2);
    }

    private String units(Cube cube) {
        Cube.Cell cell = cube.cell("");
        if (cell == null) {
            return "";
        }
        List units = Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(this.report, cell, i)).filter(Objects::nonNull).map(Cube.Indicator::units).collect(Collectors.toList());
        if (units.isEmpty() || units.contains(null)) {
            return "";
        }
        String unit = (String)units.get(0);
        return units.stream().allMatch(unit::equalsIgnoreCase) ? unit : "";
    }

    private List<Cube.Cell> cells(Cube cube, Node node) {
        if (cube.dimensions().isEmpty()) {
            return Collections.singletonList(cube.cell(""));
        }
        return cube.dimensions().stream().flatMap(d -> this.sliceStream((Dimension)d, node)).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(c -> c != null && !c.toString().isEmpty()).collect(Collectors.toList());
    }

    private Stream<String> sliceStream(Dimension dimension, Node node) {
        if (this.hasCustomSlices()) {
            return Arrays.stream(this.insight.slices());
        }
        if (!this.isNavigable(node, dimension.name())) {
            return dimension.slices(this.level()).stream().map(Slice::name);
        }
        if (!this.isCustomLevel()) {
            return node.children().stream().map(Node::name);
        }
        return dimension.slices(this.level()).stream().map(Slice::name).filter(n -> ColumnChartBuilder.isChild(node, n)).sorted();
    }

    protected List<ColumnChart.PlotLine> plotLines() {
        String definitions = this.insight.options().get("plot-lines");
        if (definitions == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(definitions.split(",")).map(line -> line.split(":")).map(d -> new ColumnChart.PlotLine(Double.parseDouble(d[0]), ((String[])d).length > 1 ? d[1] : null, ((String[])d).length > 2 ? d[2] : null)).collect(Collectors.toList());
    }

    private String onClickAction(Node node, Cube.Cell cell) {
        return this.microsite.action(node, cell.slices());
    }

    private boolean isInvalid(ColumnChart.Serie serie) {
        return !this.hasCustomSlices() && serie.isEmpty();
    }

    private boolean hasCustomSlices() {
        return this.insight.slices().length > 0;
    }

    protected boolean isNavigable(Node node, String dimension) {
        return node.dimension() != null && node.dimension().equalsIgnoreCase(dimension);
    }

    private int level() {
        return this.insight.level() != null ? this.insight.level() : 100;
    }

    private boolean isCustomLevel() {
        return this.insight.level() != null;
    }

    protected boolean isInvalid(double value) {
        return !this.insight.showZeros() && !(value > 0.0);
    }

    private static boolean isChild(Node reference, String node) {
        return reference.isMain() || node.startsWith(reference.name());
    }
}

