/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.Storyboard;
import io.intino.sumus.reporting.model.CustomIndicator;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.model.Visibility;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public interface Dashboard {
    public String name();

    public String navigation();

    public File datamart();

    public Set<String> nodes();

    public List<Report> reports();

    public boolean isRealtime();

    default public String template() {
        return "";
    }

    default public Report report(String name) {
        return this.reports().stream().filter(r -> r.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static interface Insight {
        public String id();

        public String label();

        public Type type();

        public String ledger();

        public String[] dimensions();

        public String[] filters(Timetag var1);

        public String[] dateFilters(Timetag var1);

        public String[] indicators();

        public String[] slices();

        public Integer level();

        public Visibility visibility();

        public Order order();

        public Integer maxItems();

        public Map<String, String> options();

        public Node.Type node();

        public Map<String, String> labels();

        default public String translate(String label) {
            return this.labels().getOrDefault(label, label);
        }

        public Map<String, String> formats();

        default public String format(String indicator) {
            return this.formats().get(indicator);
        }

        public static enum Type {
            Table,
            TableBar,
            Pie,
            Gauge,
            Column,
            StackedColumn,
            Microsite,
            Json,
            Html,
            TableView,
            LineView,
            HeatmapView,
            ColumnView,
            ColumnSwapView;

        }
    }

    public static interface View {
        public String name();

        public String label();

        public String ledger();

        public String[] dimensions();

        public String[] filters(Timetag var1);

        public String[] dateFilters(Timetag var1);

        public String[] indicators();

        public Integer level();

        default public Period period() {
            return new Period(Scale.Day);
        }
    }

    public static interface Report {
        public String name();

        public String label();

        public String group();

        public String description();

        public String template();

        public Set<String> ledgers();

        public List<View> views();

        public List<Insight> insights();

        public List<Storyboard> storyboards();

        public List<CustomIndicator> customIndicators();

        public List<Scale> scales();

        public Map<String, Formatter> formatters();

        public Visibility visibility();

        public String[] filters();

        public boolean requireAllLedgers();

        public boolean isSingleton();

        public boolean isRealtime();

        default public Locale locale() {
            return Locale.GERMAN;
        }

        default public Formatter formatter(String name) {
            return this.formatters().getOrDefault(name, new Formatter(this.locale()));
        }
    }
}

