package io.intino.sumus.reporting.insights;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;

import java.util.Arrays;

public class TimelineInsight extends AbstractInsight {

	public TimelineInsight(Dashboard.Insight insight) {
		super(insight);
	}

	public String view() {
		return options().get("view");
	}

	public String indicator() {
		return insight.indicators()[0];
	}

	public String drillDimension() {
		String[] dimensions = insight.dimensions();
		return dimensions.length > 0 ? dimensions[0] : null;
	}

	public String filterDimension() {
		return options().getOrDefault("filter-dimension", "");
	}

	public Period period() {
		String period = options().get("period");
		return period != null ? Period.of(period) : new Period(Scale.Month);
	}

	public Period timeUnit() {
		String period = options().get("time-unit");
		return period != null ? Period.of(period) : new Period(Scale.Day);
	}

	public boolean navFilterEnabled() {
		String value = options().get("nav-filter-enabled");
		return value == null || Boolean.parseBoolean(value);
	}

	public String plotLines() {
		return options().get("plot-lines");
	}

	public String[] viewFilter() {
		String value = options().get("view-filter");
		if (value == null) return new String[0];
		return Arrays.stream(value.split(",")).map(String::trim).toArray(String[]::new);
	}

	public boolean showDataLabels() {
		return Boolean.parseBoolean(options().get("showDataLabels"));
	}
}
