package io.intino.sumus.reporting.insights;

import io.intino.sumus.reporting.Dashboard;

import java.util.Arrays;

public class TableInsight extends AbstractInsight {

	public TableInsight(Dashboard.Insight insight) {
		super(insight);
	}

	public String[] barIndicators() {
		if (insight.type() != Type.TableBar) return new String[0];
		String data = options().get("bars");
		if (data == null) return indicators();
		return Arrays.stream(data.split(",")).map(String::trim).toArray(String[]::new);
	}
}
