package io.intino.sumus.reporting.helpers;

import java.io.*;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static java.lang.ClassLoader.getSystemClassLoader;

public class ResourceHelper {

	public static String dashboardBaseHtml() {
		return String.join(
				getResourceFileAsString("Charts.html"),
				getResourceFileAsString("ViewCharts.html"),
				getResourceFileAsString("Common.html"));
	}

	public static String getResourceFileAsString(String fileName) {
		try (InputStream is = getSystemClassLoader().getResourceAsStream(fileName)) {
			if (is == null) return "";
			try (InputStreamReader inputReader = new InputStreamReader(is);
				 BufferedReader reader = new BufferedReader(inputReader)
			) {
				return reader.lines().collect(Collectors.joining("\n"));
			}
		} catch (Throwable e) {
			return "";
		}
	}

	public static List<String> lines(File file) {
		try {
			return Files.readAllLines(file.toPath());
		} catch (IOException e) {
			return Collections.emptyList();
		}
	}
}
