package io.intino.sumus.reporting.helpers;

import java.util.List;

public class JsonHelper {

	public static final String EmptyArray = "[]";

	public static String object(List<String> parameters) {
		return object(parameters.toArray(String[]::new));
	}

	public static String object(String... parameters) {
		return "{" + String.join(",", parameters) + "}";
	}

	public static String array(List<String> objects) {
		return array(objects.toArray(String[]::new));
	}

	public static String array(String... objects) {
		return "[" + String.join(",", objects) + "]";
	}

	public static String string(String value) {
		return "\"" + value + "\"";
	}

	public static boolean isEmptyArray(String json) {
		return json != null && json.replace(" ", "").equals(EmptyArray);
	}
}
