package io.intino.sumus.reporting.builders.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ViewTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("TableViewChart"))).output(literal("<section id=\"")).output(mark("id")).output(literal("\" class=\"dashboard-section\">\n    ")).output(mark("select")).output(literal("\n    <table id=\"")).output(mark("chartID")).output(literal("\" class=\"timeline timeline-")).output(mark("classSuffix")).output(literal("\"></table>\n</section>")),
			rule().condition((type("ViewChart"))).output(literal("<section id=\"")).output(mark("id")).output(literal("\" class=\"dashboard-section\">\n    ")).output(mark("select")).output(literal("\n    <div id=\"")).output(mark("chartID")).output(literal("\" class=\"timeline timeline-")).output(mark("classSuffix")).output(literal("\"></div>\n</section>")),
			rule().condition((type("Select"))).output(literal("<select class=\"timeline\" onchange=\"")).output(mark("function")).output(literal("\">\n    <option value=\"_All\">::All::</option>\n</select>")),
			rule().condition((type("Function"))).output(mark("call")).output(literal("('")).output(mark("id")).output(literal("',")).output(mark("config")).output(literal(",[")).output(mark("dates").multiple(",")).output(literal("],'")).output(mark("label")).output(literal("',this)")),
			rule().condition((type("ViewConfig"))).output(literal("{\n    report: '")).output(mark("report")).output(literal("',\n    ledger: '")).output(mark("ledger")).output(literal("',\n    view: '")).output(mark("view")).output(literal("',\n    indicators: [")).output(mark("indicators", "Escaped").multiple(",")).output(literal("],\n    dimension: ")).output(mark("dimension")).output(literal(",\n    dimension2: '")).output(mark("dimension2")).output(literal("',\n    nodeDimension: ")).output(mark("nodeDimension")).output(literal(",\n    filters: [")).output(mark("filters", "Escaped").multiple(",")).output(literal("],\n    node: '")).output(mark("node")).output(literal("',\n    nodeID: '")).output(mark("nodeID")).output(literal("',\n    isNav: ")).output(mark("isNav")).output(literal(",\n    plotLines: [")).output(mark("plotLines").multiple(",")).output(literal("],\n    slices: ")).output(mark("slices")).output(literal(",\n    labels: ")).output(mark("labels")).output(literal(",\n    viewFilters: ")).output(mark("viewFilters")).output(literal(",\n    dateFilters: [")).output(mark("dateFilters", "Escaped").multiple(",")).output(literal("],\n    showDataLabels: ")).output(mark("showDataLabels")).output(literal(",\n}")),
			rule().condition((type("ViewLabels")), (attribute("labels"))).output(literal("{")).output(mark("labels").multiple(",")).output(literal("}")),
			rule().condition((type("ViewLabel"))).output(literal("'")).output(mark("key")).output(literal("':'")).output(mark("value")).output(literal("'")),
			rule().condition((type("ViewLabels"))).output(literal("{}")),
			rule().condition((type("ViewPlotLine")), (attribute("name")), (attribute("color"))).output(literal("{value:")).output(mark("value")).output(literal(", name:'")).output(mark("name")).output(literal("', color:'")).output(mark("color")).output(literal("'}")),
			rule().condition((type("ViewPlotLine")), (attribute("name"))).output(literal("{value:")).output(mark("value")).output(literal(", name:'")).output(mark("name")).output(literal("'}")),
			rule().condition((type("ViewPlotLine")), (attribute("color"))).output(literal("{value:")).output(mark("value")).output(literal(", color:'")).output(mark("color")).output(literal("'}")),
			rule().condition((type("ViewPlotLine"))).output(literal("{value:")).output(mark("value")).output(literal("}")),
			rule().condition((type("ViewDate"))).output(literal("{timetag:'")).output(mark("timetag")).output(literal("',label:'")).output(mark("label")).output(literal("',format:'")).output(mark("format")).output(literal("',start:'")).output(mark("start")).output(literal("',end:'")).output(mark("end")).output(literal("'}")),
			rule().condition((type("EscapedOrUndefined")), (attribute("value"))).output(literal("'")).output(mark("value")).output(literal("'")),
			rule().condition((type("EscapedOrUndefined"))).output(literal("undefined")),
			rule().condition((type("EscapedOrUndefinedArray")), (attribute("values"))).output(literal("[")).output(mark("values", "Escaped").multiple(",")).output(literal("]")),
			rule().condition((type("EscapedOrUndefinedArray"))).output(literal("undefined"))
		);
	}
}