package io.intino.sumus.reporting.builders.schemas;

import io.intino.sumus.reporting.model.Order;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import static io.intino.sumus.reporting.helpers.FormatHelper.round;

public class PieChart {

    private final String id;
    private final String title;
    private List<PieSlice> slices = Collections.emptyList();
    private double total = 0;

    public PieChart(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public PieChart slices(List<PieSlice> slices) {
        this.slices = slices;
        this.total = round(slices.stream().mapToDouble(PieSlice::value).sum(), 0);
        return this;
    }

    public static class PieSlice {

        private final String name;
        private final double value;
        private final String className;
        private String onClick;

        public PieSlice(String name, double value) {
            this.name = name;
            this.value = value;
            this.className = "pie-slice-" + name.toLowerCase().replace(" ", "");
        }

        public double value() {
            return value;
        }

        public PieSlice onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public static Comparator<? super PieSlice> sortMethodOf(Order order) {
            return (s1, s2) -> {
                if (order.is(Order.Type.Alphabetically)) return s1.name.compareTo(s2.name);
                if (order.is(Order.Type.Ascending)) return Double.compare(s1.value, s2.value);
                return Double.compare(s2.value, s1.value);
            };
        }
    }
}
