package io.intino.sumus.reporting.builders;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;

public class UIBuilderFactory {

	public static UIBuilder builderOf(Dashboard.Report report, Insight insight, Timetag timetag, Scale scale) {
		MicrositeActionBuilder microsite = new MicrositeActionBuilder(insight, report, timetag, scale);
        switch (insight.type()) {
            case Table: return new TableBuilder(report, insight, microsite);
			case TableBar: return new TableBarBuilder(report, insight, microsite);
			case Pie: return new PieChartBuilder(report, insight, microsite);
			case Gauge: return new GaugeChartBuilder(report, insight, microsite);
			case Column: return new ColumnChartBuilder(report, insight, microsite);
			case StackedColumn: return new StackedColumnChartBuilder(report, insight, microsite);
			case Microsite: return new MicrositeBuilder(insight, microsite);
			case Html: return new HtmlBuilder(insight);
			case TableView: return new TableViewBuilder(report, insight, timetag);
			case LineView: return new LineViewBuilder(report, insight, timetag);
			case ColumnView: return new ColumnViewBuilder(report, insight, timetag);
			case ColumnSwapView: return new ColumnSwapViewBuilder(report, insight, timetag);
			case HeatmapView: return new HeatmapViewBuilder(report, insight, timetag);
			default: return (cube, node) -> "";
        }
	}
}
