package io.intino.sumus.reporting.builders;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.Table.TableChartException;
import io.intino.sumus.reporting.builders.schemas.TableBar;
import io.intino.sumus.reporting.builders.templates.Renderer;

import java.util.Arrays;
import java.util.List;

public class TableBarBuilder extends TableBuilder {

    public TableBarBuilder(Dashboard.Report report, Insight insight, MicrositeActionBuilder microsite) {
        super(report, insight, microsite);
    }

    @Override
    public String build(Cube cube, Node node) {
        try {
            TableBar table = (TableBar) new TableBar(insight.id(), insight.label(), attributes(), barIndicators())
                    .globalRow(globalRow(cube))
                    .rows(rows(cube, node));

            return Renderer.render(table);
        } catch (TableChartException e) {
            Logger.error(e);
            return "";
        }
    }

    private List<String> barIndicators() {
        return Arrays.asList(insight.barIndicators());
    }
}
