package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.HtmlEmbedChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.insights.HtmlInsight;

public class HtmlBuilder implements UIBuilder {

	private final HtmlInsight insight;

	public HtmlBuilder(Insight insight) {
		this.insight = new HtmlInsight(insight);
	}

	@Override
	public String build(Cube cube, Node node) {
		HtmlEmbedChart htmlEmbed = new HtmlEmbedChart(insight.id(), insight.source());
		return Renderer.render(htmlEmbed);
	}
}
