package io.intino.sumus.reporting.builders;

import io.intino.alexandria.Timetag;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.views.ColumnViewChart;
import io.intino.sumus.reporting.builders.schemas.views.ViewChart;
import io.intino.sumus.reporting.builders.templates.Renderer;

import java.time.LocalDate;

import static io.intino.sumus.reporting.Dashboard.Insight;

public class HeatmapViewBuilder extends ViewBuilder {

	public HeatmapViewBuilder(Dashboard.Report report, Insight insight, Timetag timetag) {
		super(report, insight, timetag);
	}

	public String build(Cube cube, Node node) {
		ViewChart chart = new ColumnViewChart(insight.id(), chartID)
				.function(functionOf("ViewCharts.updateHeatmapChart", node));

		return Renderer.render(chart);
	}
}
