package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Dashboard.Insight;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.schemas.GaugeChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;

public class GaugeChartBuilder implements UIBuilder {

	private final Insight insight;
	private final Dashboard.Report report;
	private final MicrositeActionBuilder microsite;

	public GaugeChartBuilder(Dashboard.Report report, Insight insight, MicrositeActionBuilder microsite) {
		this.report = report;
		this.insight = insight;
		this.microsite = microsite;
	}

	@Override
	public String build(Cube cube, Node node) {
		GaugeChart gauge = new GaugeChart(insight.id(), insight.label())
				.value(value(cube))
				.onClick(onClickAction(node));

		return Renderer.render(gauge);
	}

	private Double value(Cube cube) {
		Cube.Cell cell = cube.cell("");
		Cube.Indicator indicator = CubesHelper.indicatorOf(report, cell, firstIndicator());
		return FormatHelper.round(CubesHelper.doubleValueOf(indicator), 1);
	}

	private String firstIndicator() {
		return insight.indicators()[0];
	}

	private String onClickAction(Node node) {
		return microsite.action(node);
	}
}
