package io.intino.sumus.reporting;

import io.intino.alexandria.Timetag;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReactiveFunctions {
    
    private static final Map<String, Function<Timetag, String>> ValueMapper = new HashMap<>();
    
    public static void add(String value, Function<Timetag, String> function) {
        ValueMapper.put(value, function);
    }
    
    public static String apply(String value, Timetag date) {
        Function<Timetag, String> mapper = ValueMapper.get(value);
        return mapper != null ? mapper.apply(date) : value;
    }
}
