/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates.html;

import io.intino.sumus.reporting.helpers.FormatHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Column {
    private final String id;
    private final String title;
    private final Set<String> categories = new LinkedHashSet<String>();
    private final Map<String, Serie> seriesMap = new LinkedHashMap<String, Serie>();
    private final Map<String, String> onClickMap = new HashMap<String, String>();
    private String units = "";

    public Column(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public Column add(String ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public Column add(Serie serie) {
        if (!this.seriesMap.containsKey(serie.name)) {
            this.seriesMap.put(serie.name, serie);
        }
        return this;
    }

    public Column add(String serie, long value) {
        this.seriesMap.putIfAbsent(serie, new Serie(serie));
        this.seriesMap.get(serie).add(value);
        return this;
    }

    public Column unit(String unit) {
        this.units = unit;
        return this;
    }

    public Column onClick(String category, String action) {
        this.onClickMap.put(category, action);
        return this;
    }

    private String categoriesJson() {
        return "[" + this.categories.stream().map(c -> "'" + FormatHelper.translationMark(c) + "'").collect(Collectors.joining(",")) + "]";
    }

    private String seriesJson() {
        return "[" + this.seriesMap.values().stream().map(Serie::json).collect(Collectors.joining(",")) + "]";
    }

    private String onClick() {
        if (this.onClickMap.isEmpty()) {
            return "undefined";
        }
        return "function(e) { " + this.onClickMap.entrySet().stream().map(e -> "if (e.point.category === '" + FormatHelper.translationMark((String)e.getKey()) + "')" + (String)e.getValue()).collect(Collectors.joining("\n")) + "}";
    }

    public String html() {
        return "<div id=\"" + this.id + "\" class=\"chart column\"></div><script>SumusCharts.column('" + this.id + "', '" + FormatHelper.translationMark(this.title) + "'," + this.categoriesJson() + "," + this.seriesJson() + ",'" + this.units + "', " + this.onClick() + ")</script>";
    }

    public Serie get(String series) {
        return this.seriesMap.get(series);
    }

    public static class Serie {
        private final String name;
        private final List<Double> values = new ArrayList<Double>();
        private String onClick;

        public Serie(String name) {
            this.name = name;
        }

        public List<Double> values() {
            return this.values;
        }

        public Serie add(double value) {
            this.values.add(value);
            return this;
        }

        public Serie onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public String json() {
            return "{ name:'" + FormatHelper.translationMark(this.name) + "', data: " + this.dataJson() + "}";
        }

        private String dataJson() {
            return "[" + this.values.stream().map(v -> "{ y: " + v + ", className: '" + this.className() + "'" + this.customs() + "}").collect(Collectors.joining(", ")) + "]";
        }

        private String className() {
            return "column-series-" + this.name.replace(" ", "").toLowerCase();
        }

        private String customs() {
            return this.onClick != null ? ", custom: { onClick: function(){" + this.onClick + "}}" : "";
        }
    }
}

