/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.insights.TimelineInsight;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ViewBuilder
implements TemplateBuilder {
    protected final TimelineInsight insight;
    protected final LocalDate date;
    protected final String report;

    public ViewBuilder(Dashboard.Report report, Dashboard.Insight insight, LocalDate date) {
        this.insight = new TimelineInsight(insight);
        this.date = date;
        this.report = report.name();
    }

    protected String chartID() {
        return this.insight.id() + "-chart";
    }

    protected String select(String id, String function, Dashboard.Node node) {
        return "<select class=\"timeline\" onchange=\"" + function + "('" + id + "'," + this.config(node) + "," + this.dates() + ",'" + this.insight.label() + "', this)\"><option value=\"_All\">::All::</option></select>";
    }

    private String config(Dashboard.Node node) {
        return JsonHelper.object("report: '" + this.report + "'", "ledger: '" + this.insight.ledger() + "'", "view: '" + this.insight.view() + "'", "indicators: " + this.escapeArray(this.insight.indicators()), "dimension: " + this.escapeOrUndefined(this.insight.drillDimension()), "dimension2: '" + this.insight.filterDimension() + "'", "nodeDimension: '" + node.dimension() + "'", "filters: " + this.escapeArray(this.insight.filters(this.date)), "node: '" + node.name() + "'", "nodeID: '" + node.id() + "'", "isNav: " + this.isNavigable(node), "plotLines: " + this.plotLines(), "slices: " + this.escapeOrUndefinedArray(this.insight.slices()), "labels: " + this.labels(), "viewFilters: " + this.escapeOrUndefinedArray(this.insight.viewFilter()));
    }

    private String dates() {
        Period period = this.insight.period();
        Period timeUnit = this.insight.timeUnit();
        return JsonHelper.array((String[])this.dates(period, timeUnit).stream().map(date -> this.toJson(timeUnit, (LocalDate)date)).toArray(String[]::new));
    }

    private List<LocalDate> dates(Period period, Period timeUnit) {
        HashSet<String> cache = new HashSet<String>();
        LinkedList<LocalDate> uniques = new LinkedList<LocalDate>();
        List<LocalDate> dates = period.isSingle() ? this.naturalDates(period) : period.dates(this.date);
        for (LocalDate date : dates) {
            String timetag = timeUnit.scale().timetag(date);
            if (cache.contains(timetag)) continue;
            cache.add(timetag);
            uniques.add(date);
        }
        return uniques;
    }

    private List<LocalDate> naturalDates(Period period) {
        Scale scale = period.scale();
        LocalDate start = scale.startDate(this.date);
        LocalDate end = scale.endDate(this.date);
        return start.datesUntil(end.plusDays(1L)).collect(Collectors.toList());
    }

    private String toJson(Period timeUnit, LocalDate date) {
        Scale timeUnitScale = timeUnit.scale();
        return JsonHelper.object("timetag: '" + timeUnitScale.timetag(date) + "'", "label: '" + timeUnitScale.label(date) + "'", "format: '" + timeUnitScale.format(date) + "'", "start:'" + Scale.Day.timetag(timeUnit.onlyLast() ? timeUnitScale.endDate(date) : timeUnitScale.startDate(date)) + "'", "end:'" + Scale.Day.timetag(timeUnitScale.endDate(date)) + "'");
    }

    private String plotLines() {
        if (this.insight.plotLines() == null) {
            return "[]";
        }
        return JsonHelper.array((String[])Arrays.stream(this.insight.plotLines().split(",")).map(line -> line.split(":")).map(this::plotLine).filter(Objects::nonNull).toArray(String[]::new));
    }

    private String plotLine(String[] data) {
        if (data.length < 1) {
            return null;
        }
        return JsonHelper.object("value: " + data[0], "name: " + (String)(data.length > 1 ? "'" + data[1] + "'" : "undefined"), "color: " + (String)(data.length > 2 ? "'" + data[2] + "'" : "undefined"));
    }

    private String labels() {
        return JsonHelper.object((String[])this.insight.labels().entrySet().stream().map(e -> "'" + (String)e.getKey() + "':'" + (String)e.getValue() + "'").toArray(String[]::new));
    }

    private boolean isNavigable(Dashboard.Node node) {
        return this.insight.navFilterEnabled() && this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private String escapeArray(String ... values) {
        return JsonHelper.array(v -> "'" + v + "'", values);
    }

    private String escapeOrUndefined(String value) {
        return value != null ? "'" + value + "'" : "undefined";
    }

    private String escapeOrUndefinedArray(String ... values) {
        if (values.length < 1 || Arrays.stream(values).allMatch(Objects::isNull)) {
            return "undefined";
        }
        return this.escapeArray(values);
    }
}

