/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.templates.html;

import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Table {
    private final String id;
    private String title = "";
    private Attribute[] attributes = new Attribute[0];
    private Row global;
    private Row[] rows = new Row[0];
    private List<String> barIndicators = new ArrayList<String>();

    public Table(String id) {
        this.id = id;
    }

    public Table title(String title) {
        this.title = title != null ? title : "";
        return this;
    }

    public Table attributes(Attribute ... attributes) {
        this.attributes = attributes;
        return this;
    }

    public Table global(Row global) {
        this.global = global;
        return this;
    }

    public Table rows(Row ... rows) {
        this.rows = rows;
        return this;
    }

    public Table bars(String ... indicators) {
        this.barIndicators = Arrays.asList(indicators);
        return this;
    }

    public boolean hasBar() {
        return !this.barIndicators.isEmpty();
    }

    public String html() {
        return "<table id='" + this.id + "' class=\"reporting-table\">" + this.colGroupTag() + "<thead><tr class=\"global-measure\">" + this.micrositeTag() + "<th class=\"table-label\"><p>" + FormatHelper.translationMark(this.title) + "</p></th>" + this.headerCells() + this.barsTag() + "</tr></thead><tbody>" + this.bodyRows() + this.summaryRow() + "</tbody></table>";
    }

    private String summaryRow() {
        if (this.global == null) {
            return "";
        }
        String bar = this.hasBar() ? "<th></th>" : "";
        return "<tr class=\"summary-row\">" + this.global.html() + bar + "</tr>";
    }

    private String micrositeTag() {
        return Arrays.stream(this.rows).allMatch(r -> r.onMicrosite != null) ? "<th class=\"microsite\"></th>" : "<th></th>";
    }

    private String headerCells() {
        return IntStream.range(0, this.attributes.length).mapToObj(this::headerCell).collect(Collectors.joining());
    }

    private String barsTag() {
        return this.hasBar() ? "<th style=\"border: none;\"></th>" : "";
    }

    private String headerCell(int column) {
        Attribute attribute = this.attributes[column];
        return "<th><p class=\"MuiTypography-root MuiTypography-body2 metric" + this.infoClass(attribute) + "\">" + FormatHelper.translationMark(attribute.label) + this.infoTag(attribute) + "</p></th>";
    }

    private String infoTag(Attribute attribute) {
        return attribute.hasInfo() ? "<span class=\"info\" title=\"" + attribute.info + "\"></span>" : "";
    }

    private String infoClass(Attribute attribute) {
        return attribute.hasInfo() ? " info-container" : "";
    }

    private String bodyRows() {
        double max = this.barsMaxValue();
        return Arrays.stream(this.rows).map(r -> "<tr>" + r.html() + this.barsTag((Row)r, max) + "</tr>").collect(Collectors.joining());
    }

    private String barsTag(Row row, double maxValue) {
        if (!this.hasBar()) {
            return "";
        }
        return "<th style=\"border: none;\"><div style=\"width: 100px;padding-left: 15px;display: flex;flex-wrap: nowrap;\">" + this.barIndicators.stream().map(indicator -> this.barTag(row, (String)indicator, maxValue)).collect(Collectors.joining()) + "</div></th>";
    }

    private String barTag(Row row, String indicator, double maxValue) {
        Value value = row.value(indicator);
        if (!value.isNumeric()) {
            return "";
        }
        double current = (Double)value.value();
        double width = maxValue != 0.0 ? current * 100.0 / maxValue : 0.0;
        String indicatorName = indicator.toLowerCase().replace(" ", "");
        return "<div class=\"table-bar table-bar-" + indicatorName + "\" style=\"height: 20px;width: " + width + "%;\"></div>";
    }

    private double barsMaxValue() {
        double max = 0.0;
        if (!this.hasBar()) {
            return max;
        }
        for (Row row : this.rows) {
            double rowValue = Arrays.stream(row.values).filter(value -> this.barIndicators.contains(value.name)).filter(Value::isNumeric).mapToDouble(value -> (Double)value.value).sum();
            if (!(rowValue > max)) continue;
            max = rowValue;
        }
        return max;
    }

    private String colGroupTag() {
        return "<colgroup><col class=\"table-col-microsite\"><col class=\"table-col-slice\">" + IntStream.range(0, this.attributes.length).mapToObj(i -> "<col class=\"table-col-indicator-" + i + "\">").collect(Collectors.joining()) + (this.hasBar() ? "<col class=\"table-bar-col\">" : "") + "</colgroup>";
    }

    public static class Value {
        String name;
        Object value;
        String units;
        Formatter formatter;

        public Value(String name, Object value, String units, Formatter formatter) {
            this.name = name;
            this.value = value;
            this.units = units != null ? units : "";
            this.formatter = formatter;
        }

        public Object value() {
            return this.value;
        }

        public boolean isNumeric() {
            return this.value instanceof Double;
        }

        public String toString() {
            String units = this.value != null ? this.units : "";
            return this.formatter.format(this.value) + units;
        }

        public static int compare(Value v1, Value v2) {
            if (v1 == null || v2 == null) {
                return 0;
            }
            return v1.isNumeric() && v2.isNumeric() ? Double.compare((Double)v1.value, (Double)v2.value) : v1.toString().compareTo(v2.toString());
        }
    }

    public static class Row {
        String name;
        Value[] values;
        String onClick;
        String onMicrosite;

        public Row(String name) {
            this.name = name;
            this.values = new Value[0];
        }

        public Value value(String name) {
            return Arrays.stream(this.values).filter(v -> v.name != null && v.name.equalsIgnoreCase(name)).findFirst().orElse(null);
        }

        public Row values(Value ... values) {
            this.values = values;
            return this;
        }

        public Row onClick(String onClick) {
            this.onClick = onClick;
            return this;
        }

        public Row onMicrosite(String onMicrosite) {
            this.onMicrosite = onMicrosite;
            return this;
        }

        public String html() {
            return this.micrositeTag() + "<th class=\"left\">" + this.nameTag() + "</th>" + this.cellTags();
        }

        private String nameTag() {
            String name = FormatHelper.translationMark(this.name);
            return this.onClick != null ? "<a onclick=\"" + this.onClick + "\">" + name + "</a>" : FormatHelper.translationMark(this.name);
        }

        private String micrositeTag() {
            if (this.onMicrosite == null) {
                return "<th></th>";
            }
            return "<th><a class=\"microsite\" title=\"" + FormatHelper.translationMark("Drill") + "\" onclick=\"" + this.onMicrosite + "\"></a></th>";
        }

        private String cellTags() {
            return Arrays.stream(this.values).map(c -> "<th>" + c + "</th>").collect(Collectors.joining(""));
        }

        public static Comparator<? super Row> sortBy(Order order) {
            if (order.is(Order.Type.Alphabetically)) {
                return Comparator.comparing(r -> r.name);
            }
            if (order.is(Order.Type.Ascending)) {
                return Row.ascendingComparator(order.indicator());
            }
            if (order.is(Order.Type.Descending)) {
                return Row.descendingComparator(order.indicator());
            }
            return (o1, o2) -> 0;
        }

        private static Comparator<Row> ascendingComparator(String indicator) {
            return (r1, r2) -> Value.compare(r1.value(indicator), r2.value(indicator));
        }

        private static Comparator<Row> descendingComparator(String indicator) {
            return (r1, r2) -> Value.compare(r2.value(indicator), r1.value(indicator));
        }
    }

    public static class Attribute {
        String label;
        String info;

        public Attribute(String label) {
            this.label = label;
        }

        public Attribute label(String label) {
            this.label = label;
            return this;
        }

        public Attribute info(String info) {
            this.info = info;
            return this;
        }

        public boolean hasInfo() {
            return this.info != null;
        }
    }
}

