/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.aggregators;

import io.intino.alexandria.Timetag;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.reporting.exceptions.AggregationException;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.model.Scale;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LedgerAggregator {
    private final File root;
    private final String separator;

    public LedgerAggregator(File root) {
        this(root, "\t");
    }

    public LedgerAggregator(File root, String separator) {
        this.root = root;
        this.separator = separator;
    }

    public String[][] aggregate(String ledger, Timetag timetag) throws AggregationException, FileNotFoundException, ParseException {
        return this.aggregate(ledger, this.loadDefinition(ledger), timetag);
    }

    public String[][] aggregate(String ledger, LedgerDefinition definition, Timetag timetag) throws AggregationException {
        Aggregator aggregator = new Aggregator(ledger, definition, timetag);
        return LedgerAggregator.isAggregable(definition) ? aggregator.aggregate() : null;
    }

    private LedgerDefinition loadDefinition(String ledger) throws ParseException, FileNotFoundException {
        File file = new File(this.root, ledger + ".ledger");
        if (!file.exists()) {
            throw new FileNotFoundException("Ledger definition " + ledger + " not found");
        }
        return LedgerDefinition.load((File)this.root, (File)file);
    }

    public static boolean isAggregable(LedgerDefinition definition) {
        return definition.aggregation != null && definition.aggregationLedger != null && definition.content == LedgerDefinition.Content.Events;
    }

    private class Aggregator {
        private final String ledger;
        private final Timetag timetag;
        private final LedgerDefinition definition;

        public Aggregator(String ledger, LedgerDefinition definition, Timetag timetag) {
            this.ledger = ledger;
            this.definition = definition;
            this.timetag = timetag;
        }

        public String[][] aggregate() throws AggregationException {
            return LedgerAggregator.isAggregable(this.definition) ? this.aggregateEvents() : null;
        }

        private String[][] aggregateEvents() throws AggregationException {
            return this.aggregateEvents(this.definition.aggregation, this.keyFunction());
        }

        private String[][] aggregateEvents(LedgerDefinition.Aggregation aggregation, Function<String, String> function) {
            Timetag from = this.getFrom(aggregation);
            return function != null ? this.aggregateFilter(from, this.timetag, function) : this.aggregateAll(from, this.timetag);
        }

        private String[][] aggregateFilter(Timetag from, Timetag to, Function<String, String> function) {
            LinkedHashMap records = new LinkedHashMap();
            this.stream(from, to).forEach(line -> {
                String key = (String)function.apply((String)line);
                if (key != null) {
                    records.put(key, line);
                }
            });
            return this.toArray(records.values().stream());
        }

        private String[][] aggregateAll(Timetag from, Timetag to) {
            return this.toArray(this.stream(from, to));
        }

        private Stream<String> stream(Timetag from, Timetag to) {
            return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::baseLedger).filter(File::exists).flatMap(f -> ResourceHelper.lines(f).stream()).filter(l -> l != null && !l.isEmpty());
        }

        private Function<String, String> keyFunction() throws AggregationException {
            String key = this.definition.aggregationKey;
            if (key == null) {
                return null;
            }
            int index = this.attributeIndex(key);
            if (index < 0) {
                throw new AggregationException("Aggregation key attribute " + key + " not found in ledger " + this.ledger);
            }
            return line -> line.split(LedgerAggregator.this.separator, -1)[index];
        }

        private String[][] toArray(Stream<String> lines) {
            return (String[][])lines.map(l -> l.split(LedgerAggregator.this.separator)).toArray((int x$0) -> new String[x$0][]);
        }

        private int attributeIndex(String aggregationKey) {
            List attributes = this.definition.attributes.stream().map(AttributeDefinition::name).collect(Collectors.toList());
            return attributes.indexOf(aggregationKey);
        }

        private File baseLedger(Timetag timetag) {
            File baseLedgerFolder = new File(LedgerAggregator.this.root, this.definition.aggregationLedger);
            return new File(baseLedgerFolder, timetag + ".tsv");
        }

        private Timetag getFrom(LedgerDefinition.Aggregation aggregation) {
            LocalDate date = this.timetag.datetime().toLocalDate();
            switch (aggregation) {
                case Week: {
                    return this.toTimetag(Scale.Week.startDate(date));
                }
                case Month: {
                    return this.toTimetag(Scale.Month.startDate(date));
                }
                case Quarter: {
                    return this.toTimetag(Scale.Quarter.startDate(date));
                }
                case Year: {
                    return this.toTimetag(Scale.Year.startDate(date));
                }
            }
            return this.timetag;
        }

        private Timetag toTimetag(LocalDate date) {
            return Timetag.of((LocalDate)date, (io.intino.alexandria.Scale)io.intino.alexandria.Scale.Day);
        }
    }
}

