/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.model.CustomIndicator;
import io.intino.sumus.reporting.model.Formatter;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.model.Visibility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DashboardDefinition {
    public static final int MaxLevel = 100;
    public static final String ReportExtension = ".report";
    private String name;
    private String datamart;
    private String definitions;
    private String navigation;
    private String nodesFile;
    private String template;
    private String[] nodes;
    private ReportDefinition[] reports;
    private String[] reportDefinitions;
    private boolean isRealtime;

    public String name() {
        return this.name != null ? this.name : "unknown";
    }

    public String navigation() {
        return this.navigation;
    }

    public File datamart() {
        return new File(this.datamart);
    }

    public File nodesFile() {
        return new File(this.nodesFile);
    }

    public Set<String> nodes() {
        return this.nodes != null ? Set.of(this.nodes) : Collections.emptySet();
    }

    public List<Dashboard.Report> reports() {
        return this.reportDefinitions().stream().map(d -> d).collect(Collectors.toList());
    }

    public List<ReportDefinition> reportDefinitions() {
        LinkedList<ReportDefinition> definitions = new LinkedList<ReportDefinition>();
        definitions.addAll(this.embeddedReportDefinitions());
        definitions.addAll(this.fileReportDefinitions());
        return definitions;
    }

    public ReportDefinition reportDefinition(String report) {
        return this.reportDefinitions().stream().filter(d -> d.name != null && d.name.equalsIgnoreCase(report)).findFirst().orElse(new ReportDefinition());
    }

    public List<ReportDefinition> reportDefinitions(String group) {
        return this.reportDefinitions().stream().filter(r -> group.equalsIgnoreCase(r.group())).collect(Collectors.toList());
    }

    private List<ReportDefinition> embeddedReportDefinitions() {
        if (this.reports == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.reports).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<ReportDefinition> fileReportDefinitions() {
        if (this.definitions == null || this.reportDefinitions.length < 1) {
            return Collections.emptyList();
        }
        File folder = new File(this.definitions);
        return Arrays.stream(this.reportDefinitions).map(name -> new File(folder, name + ReportExtension)).map(ReportDefinition::load).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> groups() {
        return this.reports().stream().map(Dashboard.Report::group).filter(group -> group != null && !group.isEmpty()).collect(Collectors.toSet());
    }

    public String template() {
        return DashboardDefinition.content(new File(this.template));
    }

    private static String content(File file) {
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            return "";
        }
    }

    public boolean isRealtime() {
        return this.isRealtime;
    }

    public static DashboardDefinition load(String definition) {
        return (DashboardDefinition)new Gson().fromJson(definition, DashboardDefinition.class);
    }

    public static class ReportDefinition
    implements Dashboard.Report {
        private String name;
        private String group;
        private String description;
        private String template;
        private Visibility visibility;
        private InsightDefinition[] insights;
        private ViewDefinition[] views;
        private CustomIndicator[] customIndicators;
        private Map<String, String> patterns;
        private boolean requireAllLedgers;
        private boolean isSingleton;
        private boolean isRealtime;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String group() {
            return this.group;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String template() {
            return DashboardDefinition.content(new File(this.template));
        }

        @Override
        public List<Dashboard.View> views() {
            if (this.views == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.views).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public List<Dashboard.Insight> insights() {
            if (this.insights == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.insights).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<InsightDefinition> insightDefinitions() {
            if (this.insights == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.insights).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @Override
        public Set<String> ledgers() {
            HashSet<String> ledgers = new HashSet<String>();
            ledgers.addAll(this.insightLedgers());
            ledgers.addAll(this.viewLedgers());
            return ledgers;
        }

        private Set<String> insightLedgers() {
            return this.insights().stream().map(Dashboard.Insight::ledger).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        private Set<String> viewLedgers() {
            return this.views().stream().map(Dashboard.View::ledger).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        public Scale[] scales() {
            return (Scale[])Arrays.stream(this.periods()).map(Period::scale).collect(Collectors.toSet()).toArray(Scale[]::new);
        }

        @Override
        public List<CustomIndicator> customIndicators() {
            if (this.customIndicators == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.customIndicators).collect(Collectors.toList());
        }

        @Override
        public Map<String, Formatter> formatters() {
            if (this.patterns == null) {
                return Collections.emptyMap();
            }
            return this.patterns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Formatter((String)e.getValue()), (a, b) -> a));
        }

        @Override
        public Visibility visibility() {
            return this.visibility != null ? this.visibility : Visibility.All;
        }

        @Override
        public boolean requireAllLedgers() {
            return this.requireAllLedgers;
        }

        @Override
        public boolean isSingleton() {
            return this.isSingleton;
        }

        @Override
        public boolean isRealtime() {
            return this.isRealtime;
        }

        public static ReportDefinition load(String definition) {
            return (ReportDefinition)new Gson().fromJson(definition, ReportDefinition.class);
        }

        public static ReportDefinition load(File definition) {
            try {
                return ReportDefinition.load(Files.readString(definition.toPath()));
            }
            catch (Throwable e) {
                Logger.warn((String)("Failed to open definition: " + definition.getAbsolutePath()));
                return null;
            }
        }

        private static class ViewDefinition
        implements Dashboard.View {
            private String label;
            private String name;
            private String ledger;
            private String[] dimensions;
            private String[] filters;
            private String[] indicators;
            private String scale;
            private Integer level;

            private ViewDefinition() {
            }

            @Override
            public String label() {
                return this.label;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String ledger() {
                return this.ledger;
            }

            @Override
            public String[] dimensions() {
                return this.dimensions != null ? this.dimensions : new String[]{};
            }

            @Override
            public String[] filters() {
                return this.filters != null ? this.filters : new String[]{};
            }

            @Override
            public String[] indicators() {
                return this.indicators != null ? this.indicators : new String[]{};
            }

            @Override
            public Integer level() {
                return this.level;
            }

            @Override
            public Period period() {
                return this.scale != null ? Period.of(this.scale) : Dashboard.View.super.period();
            }
        }

        public static class InsightDefinition
        implements Dashboard.Insight {
            private String id;
            private String label;
            private String ledger;
            private Dashboard.Insight.Type type;
            private Visibility visibility;
            private String order;
            private String[] dimensions;
            private String[] filters;
            private String[] indicators;
            private String[] slices;
            private Integer level;
            private String[] formats;
            private Integer maxItems;
            private Map<String, String> labels;
            private Map<String, String> options;
            private String node;

            @Override
            public String id() {
                return this.id;
            }

            @Override
            public String label() {
                return this.label != null ? this.label : "";
            }

            @Override
            public Dashboard.Insight.Type type() {
                return this.type;
            }

            @Override
            public String ledger() {
                return this.ledger;
            }

            @Override
            public String[] dimensions() {
                return this.dimensions != null ? this.dimensions : new String[]{};
            }

            @Override
            public String[] filters() {
                return this.filters != null ? this.filters : new String[]{};
            }

            @Override
            public String[] indicators() {
                return this.indicators != null ? this.indicators : new String[]{};
            }

            @Override
            public String[] slices() {
                return this.slices == null ? new String[]{} : this.slices;
            }

            @Override
            public Integer level() {
                return this.level;
            }

            @Override
            public Visibility visibility() {
                return this.visibility != null ? this.visibility : Visibility.All;
            }

            @Override
            public Order order() {
                if (this.order == null) {
                    return new Order(Order.Type.Descending);
                }
                if (!this.order.contains(":")) {
                    return new Order(Order.Type.valueOf(this.order));
                }
                String[] d = this.order.split(":", -1);
                return new Order(Order.Type.valueOf(d[0]), d[1]);
            }

            @Override
            public Integer maxItems() {
                return this.maxItems != null ? this.maxItems : Integer.MAX_VALUE;
            }

            @Override
            public Map<String, String> labels() {
                return this.labels != null ? this.labels : Collections.emptyMap();
            }

            @Override
            public Map<String, String> formats() {
                if (this.formats == null) {
                    return Collections.emptyMap();
                }
                return Arrays.stream(this.formats).filter(f -> f.contains(":")).map(d -> d.trim().split(":")).collect(Collectors.toMap(d -> d[0], d -> d[1], (a, b) -> a));
            }

            @Override
            public Map<String, String> options() {
                return this.options != null ? this.options : Collections.emptyMap();
            }

            @Override
            public String node() {
                return this.node;
            }
        }
    }
}

