/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.helpers.JsonHelper;
import io.intino.sumus.reporting.helpers.MinifyHelper;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import io.intino.sumus.reporting.helpers.ZipHelper;
import io.intino.sumus.reporting.model.Period;
import io.intino.sumus.reporting.model.Scale;
import io.intino.sumus.reporting.templates.NavigationBuilder;
import io.intino.sumus.reporting.templates.TemplateBuilder;
import io.intino.sumus.reporting.templates.TemplateFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DashboardBuilder {
    private static final String BaseHtml = ResourceHelper.dashboardBaseHtml();
    private final Dashboard dashboard;
    private final File folder;

    public DashboardBuilder(Dashboard dashboard, File folder) {
        this.dashboard = dashboard;
        this.folder = new File(folder, dashboard.name());
        this.folder.mkdirs();
    }

    public Dashboard dashboard() {
        return this.dashboard;
    }

    public void build(LocalDate date) {
        this.build(this.reportBuilders(date));
    }

    public void build(Dashboard.Report report, LocalDate date) {
        this.build(this.reportBuilder(report, date));
    }

    public void build(ReportBuilder ... builders) {
        Arrays.stream(builders).forEach(b -> b.build(this.folder));
    }

    public void buildViews(Dashboard.Report report, LocalDate date) {
        this.reportBuilder(report, date).buildViews(this.folder);
    }

    public String buildNodeContent(Dashboard.Report report, LocalDate date, Dashboard.Node node) {
        ReportBuilder reportBuilder = this.reportBuilder(report, date);
        return !reportBuilder.ledgersNotFound() ? reportBuilder.bodyOf(node) : null;
    }

    private ReportBuilder reportBuilder(Dashboard.Report report, LocalDate date) {
        return new ReportBuilder(report, date);
    }

    private ReportBuilder[] reportBuilders(LocalDate date) {
        return (ReportBuilder[])this.dashboard.reports().stream().map(report -> this.reportBuilder((Dashboard.Report)report, date)).toArray(ReportBuilder[]::new);
    }

    private static Filter filterOf(Ledger ledger, Dashboard.Node node, String ... filterNames) {
        List<String> filters = Arrays.stream(filterNames).collect(Collectors.toList());
        if (!node.name().isEmpty()) {
            filters.add(node.filter());
        }
        return DashboardBuilder.sliceFilterOf(ledger, filters);
    }

    private static Filter sliceFilterOf(Ledger ledger, List<String> slices) {
        return SliceFilter.of(CubesHelper.slices(ledger, slices));
    }

    private static void save(File file, String content) {
        try {
            file.getParentFile().mkdirs();
            Files.write(file.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ReportBuilder {
        public final Dashboard.Report report;
        private final Period period = new Period(Scale.Day);
        private final LocalDate date;
        private final NavigationBuilder navBuilder;
        private final Map<String, Ledger> ledgers;
        private final List<ViewBuilder> viewBuilders;
        private final List<InsightBuilder> insightBuilders;

        public ReportBuilder(Dashboard.Report report, LocalDate date) {
            this.report = report;
            this.date = date;
            this.navBuilder = new NavigationBuilder(report);
            this.ledgers = this.loadLedgers();
            this.viewBuilders = this.loadViewBuilders();
            this.insightBuilders = this.loadInsightBuilders();
        }

        public void build(File root) {
            this.buildViews(root);
            this.buildReport(root);
        }

        public void buildViews(File root) {
            this.viewBuilders.forEach(builder -> builder.build(root));
        }

        public void buildReport(File root) {
            if (this.ledgersNotFound()) {
                return;
            }
            File report = this.folder(root);
            for (Dashboard.Node node : DashboardBuilder.this.dashboard.nodes()) {
                if (!this.isVisible(node)) continue;
                File file = new File(report, this.filename(node));
                DashboardBuilder.save(file, this.bodyOf(node));
            }
            ZipHelper.zipAndRemove(report);
        }

        public String bodyOf(Dashboard.Node node) {
            String template = this.template(node);
            for (InsightBuilder b : this.insightBuilders) {
                template = template.replace(b.mark(), b.build(node));
            }
            return MinifyHelper.minify(this.replaceGenericMarks(template, node));
        }

        public File folder(File root) {
            String folderName = this.report.isSingleton() ? this.report.name() : this.period.timetag(this.date);
            return new File(root, "reports/" + this.report.name() + "/" + folderName);
        }

        public String filename(Dashboard.Node node) {
            return node.id() + ".html";
        }

        private String template(Dashboard.Node node) {
            return DashboardBuilder.this.dashboard.template() + BaseHtml + this.navBuilder.build(node) + this.template();
        }

        private String template() {
            String template = this.report.template();
            if (template != null && !template.isEmpty()) {
                return template;
            }
            return this.insightBuilders.stream().map(InsightBuilder::mark).collect(Collectors.joining("\n"));
        }

        private String replaceGenericMarks(String template, Dashboard.Node node) {
            return template.replace("::CurrentNode::", node.name().isEmpty() ? "Global" : node.name()).replace("::CurrentDay::", Scale.Day.format(this.date)).replace("::CurrentWeekDay::", Scale.Week.format(this.date)).replace("::CurrentMonth::", Scale.Month.format(this.date)).replace("::CurrentQuarter::", Scale.Quarter.format(this.date));
        }

        private boolean ledgersNotFound() {
            return this.ledgers.values().stream().allMatch(Objects::isNull);
        }

        private boolean isVisible(Dashboard.Node node) {
            return this.report.visibility().isVisible(node);
        }

        private Map<String, Ledger> loadLedgers() {
            return this.report.ledgers().stream().collect(HashMap::new, (m, l) -> m.put(l, DashboardBuilder.this.dashboard.ledger((String)l, this.period, this.date)), HashMap::putAll);
        }

        private List<InsightBuilder> loadInsightBuilders() {
            return this.report.insights().stream().map(insight -> new InsightBuilder((Dashboard.Insight)insight, this.period, this.date)).collect(Collectors.toList());
        }

        private List<ViewBuilder> loadViewBuilders() {
            return this.report.views().stream().map(insight -> new ViewBuilder((Dashboard.View)insight, this.date)).collect(Collectors.toList());
        }

        private class ViewBuilder {
            private final Dashboard.View view;
            private final LocalDate date;
            private final Ledger ledger;
            private final TemplateBuilder builder;

            public ViewBuilder(Dashboard.View view, LocalDate date) {
                this.view = view;
                this.date = date;
                this.builder = TemplateFactory.builderOf(ReportBuilder.this.report, view);
                this.ledger = DashboardBuilder.this.dashboard.ledger(view.ledger(), view.period(), date);
            }

            public void build(File root) {
                if (this.ledger == null) {
                    return;
                }
                this.buildView(this.folder(root));
            }

            private void buildView(File view) {
                for (Dashboard.Node node : DashboardBuilder.this.dashboard.nodes()) {
                    String content = this.bodyOf(node);
                    if (JsonHelper.isEmptyArray(content)) continue;
                    File file = new File(view, this.filename(node));
                    DashboardBuilder.save(file, content);
                }
                ZipHelper.zipAndRemove(view);
            }

            public String bodyOf(Dashboard.Node node) {
                return this.builder.build(this.cube(node), node);
            }

            private Cube cube(Dashboard.Node node) {
                try {
                    return this.ledger.cube().dimensions(this.dimensions()).filter(this.filterOf(node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions() {
                return Arrays.stream(this.view.dimensions()).map(arg_0 -> ((Ledger)this.ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filterOf(Dashboard.Node node) {
                return DashboardBuilder.filterOf(this.ledger, node, this.view.filters());
            }

            public File folder(File root) {
                return new File(root, "views/" + this.view.name() + "/" + this.view.period().timetag(this.date));
            }

            public String filename(Dashboard.Node node) {
                return node.id() + ".json";
            }
        }

        private class InsightBuilder {
            private final Dashboard.Insight insight;
            private final TemplateBuilder builder;

            public InsightBuilder(Dashboard.Insight insight, Period period, LocalDate date) {
                this.insight = insight;
                this.builder = TemplateFactory.builderOf(ReportBuilder.this.report, insight, date, period);
            }

            public String mark() {
                return FormatHelper.translationMark(this.insight.id());
            }

            public String build(Dashboard.Node node) {
                if (!this.isVisible(node)) {
                    return "";
                }
                Dashboard.Node dataNode = this.insightNode() != null ? this.insightNode() : node;
                return this.builder.build(this.cube(dataNode), dataNode);
            }

            private Cube cube(Dashboard.Node node) {
                Ledger ledger = ReportBuilder.this.ledgers.get(this.insight.ledger());
                return ledger != null ? this.cube(ledger, node) : CubesHelper.emptyCube();
            }

            private Cube cube(Ledger ledger, Dashboard.Node node) {
                try {
                    return ledger.cube().dimensions(this.dimensions(ledger)).filter(this.filterOf(ledger, node)).build();
                }
                catch (Throwable e) {
                    return CubesHelper.emptyCube();
                }
            }

            private List<Dimension> dimensions(Ledger ledger) {
                return Arrays.stream(this.insight.dimensions()).map(arg_0 -> ((Ledger)ledger).dimension(arg_0)).collect(Collectors.toList());
            }

            private Filter filterOf(Ledger ledger, Dashboard.Node node) {
                return DashboardBuilder.filterOf(ledger, node, this.insight.filters());
            }

            private boolean isVisible(Dashboard.Node node) {
                return this.insight.visibility().isVisible(node);
            }

            private Dashboard.Node insightNode() {
                String node = this.insight.node();
                if (node == null || node.trim().isEmpty()) {
                    return null;
                }
                return DashboardBuilder.this.dashboard.nodes().stream().filter(n -> node.equalsIgnoreCase(n.id())).findFirst().orElse(null);
            }
        }
    }
}

