parser grammar SumusGrammar;
options { tokenVocab=SumusLexer; }

root: (section NEWLINE*)* EOF;
section: IDENTIFIER body?;
body: NEW_LINE_INDENT (declaration NEWLINE+)+ DEDENT;
declaration: name COLON IDENTIFIER parameters?;
name: IDENTIFIER;
parameters : LEFT_PARENTHESIS (parameter (COMMA parameter)*)? RIGHT_PARENTHESIS;
parameter: (IDENTIFIER EQUALS)? value;

value: IDENTIFIER
		| STRING+
		| interval+
		| range+
		| integerValue+
		| doubleValue+;

integerValue: NATURAL_VALUE | NEGATIVE_VALUE | DIACRITIC;
doubleValue: integerValue | DOUBLE_VALUE;
interval: (LEFT_PARENTHESIS|LEFT_SQUARE) integerValue COMMA integerValue (RIGHT_PARENTHESIS | RIGHT_SQUARE);
range: integerValue COLON integerValue;
