/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.util;

import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.parser.SumusGrammar;
import io.intino.sumus.util.Formatters;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParseUtils {
    public static SumusGrammar.ValueContext findParameter(List<SumusGrammar.ParameterContext> parameters, String name) throws ParseException {
        if (parameters.isEmpty()) {
            throw new ParseException("Parameter " + name + " not found", 0);
        }
        return ParseUtils.findParameterValue(parameters, name).orElseThrow(() -> new ParseException("Parameter " + name + " not found", 0)).value();
    }

    public static SumusGrammar.ValueContext findParameterByNameOrPosition(List<SumusGrammar.ParameterContext> parameters, String name, int pos) throws ParseException {
        if (parameters.isEmpty()) {
            throw new ParseException("Parameter " + name + " not found", 0);
        }
        return ParseUtils.findParameterValue(parameters, name).orElse(parameters.get(pos)).value();
    }

    public static Optional<SumusGrammar.ParameterContext> findParameterValue(List<SumusGrammar.ParameterContext> parameters, String name) {
        return parameters.stream().filter(p -> p.IDENTIFIER() != null && name.equals(p.IDENTIFIER().getText())).findFirst();
    }

    public static LedgerDefinition.Content parseContent(SumusGrammar.DeclarationContext content) throws ParseException {
        try {
            return LedgerDefinition.Content.valueOf(Formatters.firstUpperCase(content.IDENTIFIER().getText()));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Unknown Property 'format' " + content.IDENTIFIER().getText() + ";", 0);
        }
    }

    public static LedgerDefinition.Format parseFormat(SumusGrammar.DeclarationContext content) throws ParseException {
        try {
            return LedgerDefinition.Format.valueOf(Formatters.firstUpperCase(content.IDENTIFIER().getText()));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Unknown Property 'format' " + content.IDENTIFIER().getText() + ";", 0);
        }
    }

    public static LedgerDefinition.Aggregation parseAggregation(String value) {
        try {
            return LedgerDefinition.Aggregation.valueOf(Formatters.firstUpperCase(value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<LedgerDefinition.Aggregation> parseAggregations(SumusGrammar.DeclarationContext content) {
        if (content == null) {
            return Collections.emptyList();
        }
        String value = content.IDENTIFIER().getText();
        return Arrays.stream(value.split("-")).map(String::trim).map(ParseUtils::parseAggregation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static SumusGrammar.DeclarationContext findDeclaration(List<SumusGrammar.DeclarationContext> declarations, String name) {
        return declarations.stream().filter(s -> s.name().getText().equals(name)).findFirst().orElse(null);
    }

    public static String findDeclarationValue(List<SumusGrammar.DeclarationContext> declarations, String name) {
        SumusGrammar.DeclarationContext declaration = ParseUtils.findDeclaration(declarations, name);
        return declaration != null ? declaration.IDENTIFIER().getText() : null;
    }

    public static List<SumusGrammar.DeclarationContext> findSection(SumusGrammar.RootContext rootContext, String name) throws ParseException {
        SumusGrammar.SectionContext sectionContext = rootContext.section().stream().filter(s -> s.IDENTIFIER().getText().equals(name)).findFirst().orElseThrow(() -> new ParseException(name + " section not found", 0));
        List<SumusGrammar.DeclarationContext> declarations = sectionContext.body().declaration();
        if (declarations.isEmpty()) {
            throw new ParseException(name + " section not found", 0);
        }
        return declarations;
    }

    public static List<SumusGrammar.DeclarationContext> safeFindSection(SumusGrammar.RootContext rootContext, String name) {
        SumusGrammar.SectionContext sectionContext = rootContext.section().stream().filter(s -> s.IDENTIFIER().getText().equals(name)).findFirst().orElse(null);
        if (sectionContext == null) {
            return Collections.emptyList();
        }
        List<SumusGrammar.DeclarationContext> declarations = sectionContext.body().declaration();
        if (declarations.isEmpty()) {
            return Collections.emptyList();
        }
        return declarations;
    }
}

