/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.parser;

import io.intino.sumus.parser.GrammarErrorListener;
import io.intino.sumus.parser.SumusErrorStrategy;
import io.intino.sumus.parser.SumusGrammar;
import io.intino.sumus.parser.SumusLexer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class SumusParser {
    private String text;

    public SumusParser(File file) {
        try {
            this.text = Files.readString(file.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            this.text = "";
        }
    }

    public SumusParser(InputStream inputStream) {
        try {
            this.text = new String(inputStream.readAllBytes());
        }
        catch (IOException e) {
            this.text = "";
        }
    }

    public SumusParser(String text) {
        this.text = text;
    }

    public SumusGrammar.RootContext parse() throws ParseException {
        try {
            SumusLexer lexer = new SumusLexer((CharStream)CharStreams.fromString((String)this.text.trim()));
            lexer.reset();
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SumusGrammar grammar = new SumusGrammar((TokenStream)tokens);
            grammar.setErrorHandler(new SumusErrorStrategy());
            grammar.addErrorListener(new GrammarErrorListener());
            return grammar.root();
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

