/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.sumus.LedgerDefinitionBuilder;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;
import io.intino.sumus.model.IndicatorDefinition;
import io.intino.sumus.util.Json;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class LedgerDefinition {
    public final Content content;
    public final Format format;
    public final List<AttributeDefinition> attributes;
    public final List<IndicatorDefinition> indicators;
    public final List<DimensionDefinition> dimensions;
    public List<Aggregation> aggregations = new ArrayList<Aggregation>();
    public String aggregationKey;

    public static LedgerDefinition load(File baseDir, File definitionFile) throws ParseException {
        return new LedgerDefinitionBuilder(baseDir).build(definitionFile);
    }

    public static LedgerDefinition load(File baseDir, String definition) throws ParseException {
        return new LedgerDefinitionBuilder(baseDir).build(definition);
    }

    public LedgerDefinition(Content content, Format format) {
        this.content = content;
        this.format = format;
        this.attributes = new ArrayList<AttributeDefinition>();
        this.indicators = new ArrayList<IndicatorDefinition>();
        this.dimensions = new ArrayList<DimensionDefinition>();
    }

    public LedgerDefinition(Content content, Format format, List<Aggregation> aggregations, String aggregationKey) {
        this(content, format);
        this.aggregationKey = aggregationKey;
        this.aggregations = aggregations;
    }

    public void add(AttributeDefinition attr) {
        this.attributes.add(attr);
    }

    public void add(IndicatorDefinition indicator) {
        this.indicators.add(indicator);
    }

    public void add(DimensionDefinition dimension) {
        this.dimensions.add(dimension);
    }

    public AttributeDefinition attribute(String name) {
        return this.attributes.stream().filter(a -> a.name().equals(name)).findFirst().orElse(null);
    }

    public String toString() {
        return Json.toJsonPretty(this);
    }

    public static enum Aggregation {
        Week,
        Month,
        Year;

    }

    public static enum Format {
        Binary,
        Tsv;

    }

    public static enum Content {
        Events,
        Status,
        Master;

    }
}

