/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.sumus.model.AttributeDefinition;
import java.util.Collections;
import java.util.List;

public class IndicatorDefinition {
    private final String name;
    private final Function function;
    private final AttributeDefinition attribute;
    private final String unit;
    private final Scale scale;
    private final List<String> filteredValues;

    public IndicatorDefinition(String name, Function function, AttributeDefinition attribute, String unit, Scale scale, List<String> filteredValues) {
        this.name = name;
        this.function = function;
        this.attribute = attribute;
        this.unit = unit;
        this.scale = scale;
        this.filteredValues = Collections.unmodifiableList(filteredValues);
    }

    public String name() {
        return this.name;
    }

    public Function function() {
        return this.function;
    }

    public Formula formula() {
        return new Formula(this.function, this.attribute);
    }

    public AttributeDefinition attribute() {
        return this.attribute;
    }

    public String unit() {
        return this.unit;
    }

    public Scale scale() {
        return this.scale;
    }

    public List<String> filteredValues() {
        return this.filteredValues;
    }

    public String label() {
        return this.function.label + "(" + this.attribute.name() + ")" + (String)(this.filteredValues.isEmpty() ? "" : " with " + String.join((CharSequence)",", this.filteredValues));
    }

    public String toString() {
        return this.label();
    }

    public static class Scale {
        private final double from;
        private final double to;

        public Scale(double from, double to) {
            this.from = from;
            this.to = to;
        }

        public double from() {
            return this.from;
        }

        public double to() {
            return this.to;
        }

        public double ratio() {
            return this.to / this.from;
        }
    }

    public static class Formula {
        public final Function function;
        public final AttributeDefinition attribute;

        public Formula(Function function, AttributeDefinition attribute) {
            this.function = function;
            this.attribute = attribute;
        }

        public String toString() {
            return this.function.label + "(" + this.attribute.name() + ")";
        }
    }

    public static enum Function {
        Count("count"),
        Ratio("ratio"),
        Sum("sum"),
        Avg("average"),
        Max("max"),
        Min("min");

        public final String label;

        private Function(String label) {
            this.label = label;
        }
    }
}

