/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.Classifier;
import io.intino.sumus.util.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class DimensionDefinition {
    private final String name;
    private final AttributeDefinition attribute;
    private final Map<String, Predicate<?>> categories;

    public DimensionDefinition(String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
        this.name = name;
        this.attribute = attribute;
        this.categories = Collections.unmodifiableMap(categories);
    }

    public AttributeDefinition attribute() {
        return this.attribute;
    }

    public String name() {
        return this.name;
    }

    public Classifier classifier() {
        return new Classifier(){

            @Override
            public List<String> categories() {
                return new ArrayList<String>(DimensionDefinition.this.categories.keySet());
            }

            @Override
            public <T> Predicate<T> predicateOf(String category) {
                return DimensionDefinition.this.categories.get(category);
            }

            @Override
            public boolean classify(String category, Object value) {
                return this.predicateOf(category).test(value);
            }
        };
    }

    public boolean isNumeric() {
        return this instanceof Numerical;
    }

    public Map<String, Predicate<?>> categories() {
        return this.categories;
    }

    public String toString() {
        return Json.toJsonPretty(this);
    }

    public static class Categorical
    extends DimensionDefinition {
        public Categorical(String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
            super(name, attribute, categories);
        }
    }

    public static class Numerical
    extends DimensionDefinition {
        public Numerical(String name, AttributeDefinition attribute, Map<String, Predicate<?>> categories) {
            super(name, attribute, categories);
        }
    }
}

